// -*- Mode : c++ -*-
//
// SUMMARY  :      
// USAGE    :        
// ORG      : 
// AUTHOR   : Frederic Hecht
// E-MAIL   : hecht@ann.jussieu.fr
//

/*
 
 This file is part of Freefem++
 
 Freefem++ is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 2.1 of the License, or
 (at your option) any later version.
 
 Freefem++  is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public License
 along with Freefem++; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "meshtype.h"
#include "Meshio.h"
namespace bamg {

	long int verbosity=2;

void (*MeshIstreamErrorHandler)(ios & ) =0;
///////////////////////////////////////////////////////////
 void WriteStr(ostream & out,char * str)
{ 
  int i=0;
  char c;
  out << '"' ;
  while (i++,c=*str++) {
   if (i==70) 
      cout << " //\n",i=0;
   if (c == '"') out << "\"\"" ;
   else out << c ;}
 out << '"' ;
}

void MeshIstream::ShowIoErr(int s) {
  LineError = 1;
  if (CurrentFile)
    cerr << " In  file " <<  CurrentFile ;
  cerr << ", Erreur Lecture "  << s << 
    ", good="  << (s & ios::goodbit) <<
    ", bad=" << (s & ios::badbit) <<
    ", fail=" << (s & ios::failbit) <<
    ", eof=" << (s & ios::eofbit) << " Line " << LineNumber <<
    endl;
  if(!in.eof()) 
    {
      in.clear(ios::goodbit);
      int i=0;
      char c;
      cerr << " the next character :" ;
      while (i++<80 && in.get(c) && (c != '\n' || i < 30 ))
	cerr.put(c);
      cerr << endl; 
    }
  if (MeshIstreamErrorHandler)
    MeshIstreamErrorHandler(in);
  else 
   { 
    in.clear(ios::failbit);
   }
}
int  MeshIstream::IsString(const char* s)
{ 
  int n=0;
  char c;
  const char * ss = s;
  while (in.get(c) && c ==' ') n++; // eat whitespace 
  if (in.good())
    while ( *ss && c == *ss && in.get(c) )
      ss++; 

  if (*ss) { // no 
    if (verbosity>9) 
      cout << "IsString: not " << s << " " << n  << "  putback " << ss-s << " :" << c  ;
    if (in.good())
      in.putback(c),ss--;
    while(ss-s>0)
      {
	cout << *ss ;
	in.putback(*ss--);
      };
    if (verbosity>9) 
      cout << ":"<< endl;
    return 0;}
  else return 1;
}

 char * MeshIstream::ReadStr()
{ 
  static char buf[1025];
  int  instr=0,k=0;
  char * b=buf, bb=0, *bend=buf+1023;
  
  for (b=buf;b<bend &&  in.get(*b);instr && b++)
    {
      int kold = k;
      if(isspace(*b))
	{
	  if (*b == '\n') LineNumber++;
	  if (instr && !bb) break;
	}
      else if (*b == bb) 
	{
	  if(++k%2) b--;
	}
      else if( !instr) 
	{
	  instr =1;
	  if  ((*b == '"') ||  (*b == '\'' ) )
	    bb=*b--,k=0;
	}
      else
	instr =1;
      
      if( k%2 && kold==k ) // even and fin
	break;
    }
  *b=0;
  in.clear(ios::goodbit);
  //  cout << " l = " << b-buf << " " ;
  char * r = new char [b-buf+1];
  strcpy(r,buf);
  return r ;  
}
}// end of namespace bamg 
