/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   i;
	BamgArgs bamgargs;
	BamgMesh bamgmesh;
	BamgGeom bamggeom;

	/*Mesh inputs*/
	int     NumVerticesMesh;
	double* VerticesMesh=NULL;
	int     NumTrianglesMesh;
	double* TrianglesMesh=NULL;

	/*Geom inputs: */
	int     NumVerticesGeom;
	double* VerticesGeom=NULL;
	int     NumEdgesGeom;
	double* EdgesGeom=NULL;
	double* hVerticesGeom=NULL;
	double  MaximalAngleOfCorner;
	int     NumSubDomainGeom;
	double* SubDomainGeom=NULL;

	/*Options inputs*/
	int    iso,maxnbv,verbose,splitcorners;
	double hmin,hmax;
	double gradation;
	double cutoff;
	double* metric;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	FetchData(&NumVerticesGeom,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	bamggeom.NumVertices=NumVerticesGeom;
	FetchData(&VerticesGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	bamggeom.Vertices=VerticesGeom;
	FetchData(&NumEdgesGeom,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	bamggeom.NumEdges=NumEdgesGeom;
	FetchData(&EdgesGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	bamggeom.Edges=EdgesGeom;
	FetchData(&hVerticesGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	bamggeom.hVertices=hVerticesGeom;
	bamggeom.MetricVertices=NULL;
	bamggeom.h1h2VpVertices=NULL;
	FetchData(&MaximalAngleOfCorner,mxGetField(BAMGGEOMETRY,0,"MaximalAngleOfCorner"));
	bamggeom.MaximalAngleOfCorner=MaximalAngleOfCorner;
	bamggeom.NumTangentAtEdges=0;
	bamggeom.TangentAtEdges=NULL;
	bamggeom.NumCorners=0;
	bamggeom.Corners=NULL;
	bamggeom.NumRequiredVertices=0;
	bamggeom.RequiredVertices=NULL;
	bamggeom.NumRequiredEdges=0;
	bamggeom.RequiredEdges=NULL;
	FetchData(&NumSubDomainGeom,mxGetField(BAMGGEOMETRY,0,"NumSubDomain"));
	bamggeom.NumSubDomain=NumSubDomainGeom;
	FetchData(&SubDomainGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"SubDomain"));
	bamggeom.SubDomain=SubDomainGeom;

	/*create bamg mesh input*/
	FetchData(&NumVerticesMesh,mxGetField(BAMGMESH,0,"NumVertices"));
	bamgmesh.NumVertices=NumVerticesMesh;
	FetchData(&VerticesMesh,NULL,NULL,mxGetField(BAMGMESH,0,"Vertices"));
	bamgmesh.Vertices=VerticesMesh;
	FetchData(&NumTrianglesMesh,mxGetField(BAMGMESH,0,"NumTriangles"));
	bamgmesh.NumTriangles=NumTrianglesMesh;
	FetchData(&TrianglesMesh,NULL,NULL,mxGetField(BAMGMESH,0,"Triangles"));
	bamgmesh.Triangles=TrianglesMesh;
	bamgmesh.hVertices=NULL;
	bamgmesh.NumQuadrilaterals=0;
	bamgmesh.Quadrilaterals=NULL;
	bamgmesh.NumVertexOnGeometricEdge=0;
	bamgmesh.VertexOnGeometricEdge=NULL;
	bamgmesh.NumEdgeOnGeometricEdge=0;
	bamgmesh.EdgeOnGeometricEdge=NULL;
	bamgmesh.NumEdges=0;
	bamgmesh.Edges=NULL;
	bamgmesh.NumSubDomain=0;
	bamgmesh.SubDomain=NULL;

	/*create bamg options input*/
	FetchData(&iso,mxGetField(BAMGOPTIONS,0,"iso"));
	bamgargs.iso=iso;
	FetchData(&maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	bamgargs.maxnbv=maxnbv;
	FetchData(&hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	bamgargs.hmin=hmin;
	FetchData(&hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	bamgargs.hmax=hmax;
	FetchData(&gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	bamgargs.gradation=gradation;
	FetchData(&cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	bamgargs.cutoff=cutoff;
	FetchData(&verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	bamgargs.verbose=verbose;
	FetchData(&splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	bamgargs.splitcorners=splitcorners;
	FetchData(&metric,NULL,NULL,mxGetField(BAMGOPTIONS,0,"metric"));
	bamgargs.metric=metric;

	/*!Generate internal degree of freedom numbers: */
	Bamgx(&bamgmesh,&bamggeom,&bamgargs);

	/*write output datasets: */
	WriteData(TRIANGLESOUT,bamgmesh.Triangles,bamgmesh.NumTriangles,4);
	WriteData(VERTICESOUT,bamgmesh.Vertices,bamgmesh.NumVertices,3);

	/*Free ressources: */
	xfree((void**)&VerticesGeom);
	xfree((void**)&EdgesGeom);
	xfree((void**)&hVerticesGeom);
	xfree((void**)&SubDomainGeom);
	//xfree((void**)&TrianglesMesh);
	//xfree((void**)&VerticesMesh);

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,x,y]=%s(bamgmesh,bamggeom,bamgoptions,nbv);\n",__FUNCT__);
	_printf_("\n");
}
