/*!\file Bamgx
 * \brief: use Bamg capabilities.
 */

#include "./Bamgx.h"

#undef __FUNCT__ 
#define __FUNCT__ "Bamgx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"

/*Bamg: */
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <new>
#include <cassert>
#include <iomanip>
#include <fstream>
#include "Meshio.h"
#include "Mesh2.h"
#include "QuadTree.h"

using namespace bamg;
using namespace std;

int Bamgx(BamgMesh* bamgmesh,BamgGeom* bamggeom,BamgArgs* bamgargs){
	
	int noerr=1;

	/*output: */
	double* elementsout=NULL;
	double* xout=NULL;
	double* yout=NULL;
	int     nelout, nodsout;

	/*Bamg options*/
	int    iso;
	int    maxnbv;
	double hmin,hmax;
	double gradation;
	double cutoff;
	int    verbosity;
	int    splitcorners;

	/*Bamg variables: */
	int i,j,num;
	hinterpole=1; // by def interpolation a h 
	int fileout=0;
	int AbsError=0,nbjacoby=1,allquad=0;
	int NoMeshReconstruction=0;
	int Rescaling = 1;
	double costheta=2;
	Real8 cutoffradian=-1;
	double anisomax = 1e6;
	double err=0.01,errg=0.1,coef=1;
	int KeepBackVertices=1;
	double hminaniso=1e-100; 
	const double  boundmaxsubdiv = 10;
	double  maxsubdiv=boundmaxsubdiv;
	double omega=1.8;
	int NbSmooth=3;
	double *solMbb =0,*solMBB=0;
	int  *typesolsBB =0;
	Int4 nbsolbb=0,lsolbb=0;
	Int4 nbsolBB=0,lsolBB=0;
	int rbbeqMbb=0,rBBeqMBB=0;
	int ChoiseHessien = 0;
	double power=1;
	Triangles *Thr=0,*Thb=0;
	char *fmeshback=0,*fmeshout=0,*fmeshr=0,*fmetrix=0,*famfmt=0,*fmsh=0,
		 *fnopo=0,*fftq=0,*fam=0,*famdba=0,*rbb=0,*rBB=0,*wbb=0,*wBB=0,
		 *fMbb=0,*foM=0,*fMBB=0;
	char *datargv[128] ;
	int datargc=1;
	datargv[0]= datargv[1]=0;// for create a error if no parameter 

	/*Bamg options*/
	iso=bamgargs->iso;
	maxnbv=bamgargs->maxnbv;
	hmin=bamgargs->hmin;
	hmax=bamgargs->hmax;
	gradation=bamgargs->gradation;
	cutoff=bamgargs->cutoff;
	verbosity=bamgargs->verbose;
	splitcorners=bamgargs->splitcorners;

	// some verification
	NoMeshReconstruction= fmeshr !=0;
	if (!fmeshback) fmeshback=fmeshr;
	if ( maxsubdiv > boundmaxsubdiv || maxsubdiv <= 1.0)
	{
		cerr << " -maxsubdiv " << maxsubdiv << " is not in ]1,"<< boundmaxsubdiv << "]" << endl;
		exit(3);
	}
	if (iso) anisomax=1;
	if (!(fmetrix||fMbb))
		NbSmooth=0; // no metric -> no smoothing 
	if( ! rbb) // to set the rbb filename by default 
		rbb=fMbb;
	if( ! rBB) // to set the rbb filename by default 
		rBB=fMBB;

	if (fMbb && rbb) 
		rbbeqMbb = !strcmp(rbb,fMbb);
	if (fMBB && rBB) 
		rBBeqMBB = !strcmp(rBB,fMBB);

	if(bamgmesh->numberofelements==0){
		/*Mesh generation {{{1*/
		if (verbosity>0) printf("Construction of a mesh from a given geometry\n");
		Geometry Gh(bamggeom,bamgargs);
		hmin = Max(hmin,Gh.MinimalHmin());
		hmax = Min(hmax,Gh.MaximalHmax());

		//build metric if not given in input
		for(i=0;i<Gh.nbv;i++)
		  {
			MetricAnIso M=Gh[i];
			MatVVP2x2 Vp(M/coef);
			Vp.Maxh(hmin);
			Vp.Minh(hmax);
			Gh.vertices[i].m = Vp;
		  }

		//generate mesh
		Triangles Th(maxnbv,Gh);
		if(splitcorners) Th.SplitInternalEdgeWithBorderVertices();
		Th.ReNumberingTheTriangleBySubDomain();
		//if(NbSmooth>0) Th.SmoothingVertex(NbSmooth,omega);
		Th.SmoothingVertex(3,omega);

		//Build output
		nelout=Th.nbt-Th.NbOutT; //number of triangles - number of external triangles
		nodsout=Th.nbv;

		xout=(double*)xmalloc(nodsout*sizeof(double));
		yout=(double*)xmalloc(nodsout*sizeof(double));
		for (i=0;i<nodsout;i++){
			xout[i]=Th.vertices[i].r.x;
			yout[i]=Th.vertices[i].r.y;
		}

		elementsout=(double*)xmalloc(3*nelout*sizeof(double));
		num=0;
		for(i=0;i<Th.nbt;i++){ 
			Triangle &t=Th.triangles[i];
			if (t.link){
				//write the element only if it is part of the mesh (no boundary element)
				elementsout[3*num+0]=Th.Number(t[0])+1;
				elementsout[3*num+1]=Th.Number(t[1])+1;
				elementsout[3*num+2]=Th.Number(t[2])+1;
				num=num+1;
			}
		}
		/*}}}*/
	}

	else{
		/*Anisotropic mesh adaptation {{{1*/
		if (verbosity>0) printf("Anisotropic mesh adaptation\n");

		/*Read background mesh from simple delaunay triangulation: */
		Triangles BTh(bamgmesh,bamgargs); // read the background mesh 

		hmin = Max(hmin,BTh.MinimalHmin());
		hmax = Min(hmax,BTh.MaximalHmax());

		throw ErrorException(__FUNCT__," done");

		BTh.MakeQuadTree();
		if (fmetrix){
			BTh.ReadMetric(fmetrix,hmin,hmax,coef);
		}
		else { // init with hmax 
			Metric Mhmax(hmax);
			for (Int4 iv=0;iv<BTh.nbv;iv++)
			 BTh[iv].m = Mhmax;
		}
		if (fMbb) {
			solMbb = ReadbbFile(fMbb,nbsolbb,lsolbb,2,2);
			if (lsolbb != BTh.nbv) 
			  {
				cerr << "fatal error  nbsol " << nbsolbb << " " << lsolbb<< " =! " << BTh.nbv << endl;
				cerr << "  size of sol incorrect " << endl;
				MeshError(99);
			  }
			assert(lsolbb==BTh.nbv);
			BTh.IntersectConsMetric(solMbb,nbsolbb,0,hmin,hmax,sqrt(err)*coef,1e30,AbsError?0.0:cutoff,
						nbjacoby,Rescaling,power,ChoiseHessien);
			if(!rbbeqMbb)
			 delete [] solMbb,solMbb =0;

		}
		if (fMBB) {
			solMBB = ReadBBFile(fMBB,nbsolBB,lsolBB,typesolsBB,2,2);
			if (lsolBB != BTh.nbv) 
			  {
				cerr << "fatal error  nbsol " << nbsolBB << " " << lsolBB << " =! " << BTh.nbv << endl;
				cerr << "  size of sol incorrect " << endl;
				MeshError(99);
			  }
			assert(lsolBB==BTh.nbv);
			BTh.IntersectConsMetric(solMBB,nbsolBB,0,hmin,hmax,sqrt(err)*coef,1e30,AbsError?0.0:cutoff,
						nbjacoby,Rescaling,ChoiseHessien);
			if(!rBBeqMBB)
			 delete [] solMBB,solMBB =0;

		}

		BTh.IntersectGeomMetric(errg,iso);

		if(gradation) BTh.SmoothMetric(gradation);
		BTh.MaxSubDivision(maxsubdiv);
		BTh.BoundAnisotropy(anisomax,hminaniso);

		if(foM) {
			if(verbosity >2)
			 cout << " -- write Metric  file " << foM <<endl;

			ofstream f(foM);
			if(f) BTh.WriteMetric(f,iso);
		}

		if ( fileout) {
			if ( NoMeshReconstruction)
			 if (( fmeshback == fmeshr) || (!strcmp(fmeshback,fmeshr)))
			  Thr=&BTh,Thb=0; // back and r mesh are the same 
			 else
			  Thr= new Triangles(fmeshr,cutoffradian),Thb=&BTh; // read the new 



			Triangles & Th( *(NoMeshReconstruction 
							?  new Triangles(*Thr,&Thr->Gh,Thb,maxnbv) // copy the mesh + free space to modification  
							:  new Triangles(maxnbv,BTh,KeepBackVertices)     // construct a new mesh 
							));
			if (Thr != &BTh) delete Thr;

			if(costheta<=1.0)
			 Th.MakeQuadrangles(costheta);
			if (allquad)
			 Th.SplitElement(allquad==2);
			if(splitcorners)
			 Th.SplitInternalEdgeWithBorderVertices();
			Th.ReNumberingTheTriangleBySubDomain();

			if(verbosity>3) Th.ShowHistogram();
			if(NbSmooth>0) Th.SmoothingVertex(NbSmooth,omega);
			if(verbosity>3 && NbSmooth>0) Th.ShowHistogram();

			Th.BTh.ReMakeTriangleContainingTheVertex();

			if (fmeshout) Th.Write(fmeshout  ,Triangles::BDMesh);
			if (famfmt)   Th.Write(famfmt    ,Triangles::am_fmtMesh);
			if (fam)      Th.Write(fam       ,Triangles::amMesh);
			if (famdba)   Th.Write(famdba    ,Triangles::amdbaMesh);
			if (fftq)     Th.Write(fftq      ,Triangles::ftqMesh);
			if (fmsh)     Th.Write(fmsh      ,Triangles::mshMesh);
			if (fnopo)    Th.Write(fnopo     ,Triangles::NOPOMesh);

			if ( ( rbb && wbb)  ||( rBB && wBB)){  // the code for interpolation 

				if(verbosity >1)
				  {
					if (rbb ) 
					 cout << " -- interpolation P1  files : " << rbb << " -> " << wbb <<endl;
					if (rBB ) 
					 cout << " -- interpolation P1  files : " << rBB<< " -> " << wBB <<endl;
				  }
				const int dim=2;
				// optimisation read only si rbb != fMbb

				double *solbb=0;
				double *solBB=0;

				if (rbb) 
				 solbb =  rbbeqMbb? solMbb : ReadbbFile(rbb,nbsolbb,lsolbb,2,2);
				if (rBB) 
				 solBB =  rBBeqMBB? solMBB : ReadBBFile(rBB,nbsolBB,lsolBB,typesolsBB,2,2);

				// cout << " " << rbbeqMbb << " " <<  sol << " " << nbsol << " " << lsol << endl; 
				if (!solBB && !solbb ) 
				  {
					cerr << " Fatal Error "  << "solBB =  " <<  solBB << " solbb= " << solbb << endl;
					exit(2);}

					ofstream *fbb = wbb ? new ofstream(wbb) :0;
					ofstream *fBB = wBB ? new ofstream(wBB) :0;
					Int4   nbfieldBB = 0, nbfieldbb = nbsolbb;
					if (fbb)
					 *fbb  << dim << " " << nbsolbb << " " << Th.nbv <<" " << 2 << endl; 
					if (fBB)
					  {
						int i;
						*fBB  << dim << " " << nbsolBB ;
						for ( i=0;i<nbsolBB;i++)
						 *fBB << " " << (typesolsBB ?typesolsBB[i]+1:1) ;
						*fBB << " " << Th.nbv <<" " << 2 << endl; 
						assert(dim==2);
						for ( i=0;i<nbsolBB;i++)
						 nbfieldBB += typesolsBB ? typesolsBB[i]+1 : 1;
						// this code is good only if dim == 2 
					  }
					cout << "nb of field BB " << nbfieldBB << endl;
					//		 if(fBB) fBB->precision(15);
					//if(fbb) fbb->precision(15);
					for(i=0;i<Th.nbv;i++)
					  {
						Int4 i0,i1,i2;
						double a[3];
						Icoor2 dete[3];
						I2 I = Th.BTh.toI2(Th.vertices[i].r);
						Triangle & tb = *Th.BTh.FindTriangleContening(I,dete);

						if (tb.det>0) { // internal point 
							a[0]= (Real8) dete[0]/ tb.det;
							a[1]= (Real8) dete[1] / tb.det;
							a[2] = (Real8) dete[2] / tb.det;
							i0=Th.BTh.Number(tb[0]);
							i1=Th.BTh.Number(tb[1]);
							i2=Th.BTh.Number(tb[2]);}
						else {
							double aa,bb;

							TriangleAdjacent  ta=CloseBoundaryEdge(I,&tb,aa,bb).Adj();

							int k = ta;
							Triangle & tc = *(Triangle *)ta;
							i0=Th.BTh.Number(tc[0]);
							i1=Th.BTh.Number(tc[1]);
							i2=Th.BTh.Number(tc[2]);
							a[VerticesOfTriangularEdge[k][1]] =aa;
							a[VerticesOfTriangularEdge[k][0]] = bb;
							a[OppositeVertex[k]] = 1- aa -bb;}

							Int4  ibb0 = nbfieldbb*i0;
							Int4  ibb1 = nbfieldbb*i1;
							Int4  ibb2 = nbfieldbb*i2;

							Int4  iBB0 = nbfieldBB*i0;
							Int4  iBB1 = nbfieldBB*i1;
							Int4  iBB2 = nbfieldBB*i2;
							Int4 j=0;

							for ( j=0;j<nbfieldbb;j++) 
							 *fbb  << " " << ( a[0] * solbb[ibb0++] + a[1] * solbb[ibb1++] + a[2]* solbb[ibb2++]) ;

							for (j=0;j<nbfieldBB;j++) 
							 *fBB  << " " << ( a[0] * solBB[iBB0++] + a[1] * solBB[iBB1++] + a[2]* solBB[iBB2++]) ;

							if (fbb) *fbb  << endl;
							if (fBB) *fBB  << endl;
					  }
					if (fbb)
					 delete fbb  ; // close
					if (fBB)
					 delete fBB  ; // close
					if (solbb) 
					 delete [] solbb;
					if (solBB) 
					 delete [] solBB;

			}

			if(verbosity>0) 
			  {
				if (Th.nbt-Th.NbOutT-Th.NbOfQuad*2) 
				 cout  << " Nb Triangles = " << (Th.nbt-Th.NbOutT-Th.NbOfQuad*2);
				if (Th.NbOfQuad ) 
				 cout  << " Nb Quadrilaterals = " << Th.NbOfQuad  ;
				cout   << endl;
			  }

			//Build output
			nelout=Th.nbt-Th.NbOutT; //number of triangles - number of external triangles
			nodsout=Th.nbv;

			xout=(double*)xmalloc(nodsout*sizeof(double));
			yout=(double*)xmalloc(nodsout*sizeof(double));
			for (i=0;i<nodsout;i++){
				xout[i]=Th.vertices[i].r.x;
				yout[i]=Th.vertices[i].r.y;
			}

			elementsout=(double*)xmalloc(3*nelout*sizeof(double));
			num=0;
			for(i=0;i<Th.nbt;i++){ 
				Triangle &t=Th.triangles[i];
				if (t.link){
					//write the element only if it is part of the mesh (no boundary element)
					elementsout[3*num+0]=Th.Number(t[0])+1;
					elementsout[3*num+1]=Th.Number(t[1])+1;
					elementsout[3*num+2]=Th.Number(t[2])+1;
					num=num+1;
				}
			}

			/*clean up*/
			delete &Th;
		}
		/*}}}*/
	}

	/*Assign output pointers*/
	bamgmesh->numberofelements=nelout;
	bamgmesh->numberofnodes=nodsout;
	xfree((void**)&bamgmesh->index);
	bamgmesh->index=elementsout;
	xfree((void**)&bamgmesh->x);
	bamgmesh->x=xout;
	xfree((void**)&bamgmesh->y);
	bamgmesh->y=yout;

	/*No error return*/
	return noerr;

}
