/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   i;
	BamgArgs bamgargs;
	BamgMesh bamgmesh;
	BamgGeom bamggeom;

	/*Mesh inputs*/
	int     numberofnodes;
	int     numberofelements;
	double* x;
	double* y;
	double* index;

	/*Geom inputs: */
	int     NumVertices;
	double* Vertices=NULL;
	int     NumEdges;
	double* Edges=NULL;
	double* hVertices=NULL;
	int     NumSubDomain;
	double* SubDomain=NULL;

	/*Options inputs*/
	int    iso;
	double hmin,hmax;
	double gradation;
	double cutoff;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	FetchData(&NumVertices,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	bamggeom.NumVertices=NumVertices;
	FetchData(&Vertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	bamggeom.Vertices=Vertices;
	FetchData(&NumEdges,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	bamggeom.NumEdges=NumEdges;
	FetchData(&Edges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	bamggeom.Edges=Edges;
	FetchData(&hVertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	bamggeom.hVertices=hVertices;
	bamggeom.Edges=Edges;
	bamggeom.MetricVertices=NULL;
	bamggeom.h1h2VpVertices=NULL;
	bamggeom.MaximalAngleOfCorner=10;
	bamggeom.NumTangentAtEdges=0;
	bamggeom.TangentAtEdges=NULL;
	bamggeom.NumCorners=0;
	bamggeom.Corners=NULL;
	bamggeom.NumRequiredVertices=0;
	bamggeom.RequiredVertices=NULL;
	bamggeom.NumRequiredEdges=0;
	bamggeom.RequiredEdges=NULL;
	FetchData(&NumSubDomain,mxGetField(BAMGGEOMETRY,0,"NumSubDomain"));
	bamggeom.NumSubDomain=NumSubDomain;
	FetchData(&SubDomain,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"SubDomain"));
	bamggeom.SubDomain=SubDomain;

	/*create bamg mesh input*/
	FetchData(&numberofnodes,mxGetField(BAMGMESH,0,"numberofnodes"));
	bamgmesh.numberofnodes=numberofnodes;
	FetchData(&numberofelements,mxGetField(BAMGMESH,0,"numberofelements"));
	bamgmesh.numberofelements=numberofelements;
	FetchData(&x,NULL,NULL,mxGetField(BAMGMESH,0,"x"));
	bamgmesh.x=x;
	FetchData(&y,NULL,NULL,mxGetField(BAMGMESH,0,"y"));
	bamgmesh.y=y;
	FetchData(&index,NULL,NULL,mxGetField(BAMGMESH,0,"index"));
	bamgmesh.index=index;

	/*create bamg options input*/
	FetchData(&iso,mxGetField(BAMGOPTIONS,0,"iso"));
	bamgargs.iso=iso;
	FetchData(&hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	bamgargs.hmin=hmin;
	FetchData(&hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	bamgargs.hmax=hmax;
	FetchData(&gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	bamgargs.gradation=gradation;
	FetchData(&cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	bamgargs.cutoff=cutoff;

	/*!Generate internal degree of freedom numbers: */
	Bamgx(&bamgmesh,&bamggeom,&bamgargs);

	/*write output datasets: */
	WriteData(ELEMENTSOUT,bamgmesh.index,bamgmesh.numberofelements,3);
	WriteData(XOUT,bamgmesh.x,bamgmesh.numberofnodes);
	WriteData(YOUT,bamgmesh.y,bamgmesh.numberofnodes);

	/*Free ressources: */
	xfree((void**)&Vertices);
	xfree((void**)&Edges);
	xfree((void**)&hVertices);
	xfree((void**)&SubDomain);

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,x,y]=%s(bamgmesh,bamggeom,bamgoptions,nbv);\n",__FUNCT__);
	_printf_("\n");
}
