function md=bamg(md,varargin)
%BAMG - mesh generation
%
%   Usage:
%      md=bamg(md,varargin);

%process options
options=pairoptions(varargin{:});

%initialize the structures required as input of Bamg
bamg_options=struct();
bamg_geometry=struct();
bamg_mesh=struct();

% Bamg Geometry parameters {{{1
bamg_geometry.NumVertices=0;
bamg_geometry.Vertices=zeros(0,3);
bamg_geometry.NumEdges=0;
bamg_geometry.Edges=zeros(0,3);
bamg_geometry.hVertices=zeros(0,1);
bamg_geometry.NumSubDomain=0;
bamg_geometry.SubDomain=zeros(0,3);
if exist(options,'domain'),
	domainfile=getfieldvalueerr(options,'domain');
	if ~exist(domainfile,'file')
		error(['bamg error message: file ' domainfile ' not found ']);
	else
		domain=expread(domainfile);

		%build geometry
		count=0;

		for i=1:length(domain),
			nods=domain(i).nods-1; %the domain are closed 1=end;
			bamg_geometry.Vertices=[bamg_geometry.Vertices; [domain(i).x(1:nods) domain(i).y(1:nods) ones(nods,1)]];
			bamg_geometry.Edges=[bamg_geometry.Edges; [transp(count+1:count+nods) transp([count+2:count+nods count+1])  ones(nods,1)]];
			bamg_geometry.hVertices=[];%[bamg_geometry.hVertices; resolution*ones(nods,1)];
			if i>1,
				clockwise=-1;
				bamg_geometry.SubDomain=[2 count+1 clockwise 1];
			end
			count=count+nods;
		end
		bamg_geometry.NumVertices=size(bamg_geometry.Vertices,1);
		bamg_geometry.NumEdges=size(bamg_geometry.Edges,1);
		bamg_geometry.NumSubDomain=size(bamg_geometry.SubDomain,1);
	end 
end
%}}}

% Bamg Mesh parameters {{{1
bamg_mesh.numberofelements=0;
bamg_mesh.numberofnodes=0;
bamg_mesh.x=[];
bamg_mesh.y=[];
bamg_mesh.index=zeros(0,3);
if (~exist(options,'domain') & md.numberofgrids~=0 & strcmpi(md.type,'2d')),
	bamg_mesh.numberofelements=md.numberofelements;
	bamg_mesh.numberofnodes=md.numberofgrids;
	bamg_mesh.x=md.x;
	bamg_mesh.y=md.y;
	bamg_mesh.index=md.elements;
end
%}}}

% Bamg Options {{{1
bamg_options.iso=getfieldvalue(options,'iso',0);
bamg_options.hmin=getfieldvalue(options,'hmin',10^-100);
bamg_options.hmax=getfieldvalue(options,'hmax',10^100);
bamg_options.gradation=getfieldvalue(options,'gradation',1.2);
bamg_options.cutoff=getfieldvalue(options,'cutoff',10^-5);
%}}}

%call Bamg
[elements,x,y]=Bamg(bamg_mesh,bamg_geometry,bamg_options);

% plug results onto model
md.x=x;
md.y=y;
md.elements=elements;

%Fill in rest of fields:
md.numberofelements=length(md.elements);
md.numberofgrids=length(md.x);
md.z=zeros(md.numberofgrids,1);
md.type='2d';
