function md=bamg(md,varargin)
%BAMG - mesh generation
%
%   Usage:
%      md=bamg(md,varargin);

%process options
options=pairoptions(varargin{:});

%initialize the structures required as input of Bamg
bamg_options=struct();
bamg_geometry=struct();
bamg_mesh=struct();

%get domainoutline
domainfile=getfieldvalueerr(options,'domain');
resolution=getfieldvalue(options,'resolution',5000);
if ~exist(domainfile,'file')
	error(['bamg error message: file ' domainfile ' not found ']);
else
	domain=expread(domainfile);

	%build geometry
	count=0;
	bamg_geometry.Vertices=zeros(0,3);
	bamg_geometry.Edges=zeros(0,3);
	bamg_geometry.hVertices=zeros(0,1);
	bamg_geometry.SubDomain=zeros(0,3);
	for i=1:length(domain),
		nods=domain(i).nods-1; %the domain are closed 1=end;
		bamg_geometry.Vertices=[bamg_geometry.Vertices; [domain(i).x(1:nods) domain(i).y(1:nods) ones(nods,1)]];
		bamg_geometry.Edges=[bamg_geometry.Edges; [transp(count+1:count+nods) transp([count+2:count+nods count+1])  ones(nods,1)]];
		bamg_geometry.hVertices=[bamg_geometry.hVertices; resolution*ones(nods,1)];
		if i>1,
			bamg_geometry.SubDomain=[2 count+1 1 1];
		end
		count=count+nods;
	end
	bamg_geometry.NumVertices=size(bamg_geometry.Vertices,1);
	bamg_geometry.NumEdges=size(bamg_geometry.Edges,1);
	bamg_geometry.NumSubDomain=size(bamg_geometry.SubDomain,1);
end

%call Bamg
[elements,x,y]=Bamg(bamg_geometry,bamg_options);

% plug results onto model
md.x=x;
md.y=y;
md.elements=elements;

%Fill in rest of fields:
md.numberofelements=length(md.elements);
md.numberofgrids=length(md.x);
md.z=zeros(md.numberofgrids,1);
md.type='2d';
