/*!\file:  AverageFilter.cpp
 * \brief fill holes in matlab velocity array
	this matlab module is an adaptation of a routine written by Robber 
	Crippen.  The original routine was designed for the SRTM mission at JPL, 
	and can be found in the current directory, under the name 
	AverageFilterCrippen.  It fills void holes in an image, using an interpolation 
	algorithm, and optionnally a smoothing algorithm. 
	This matlab module extends the Crippen routine to be used in Matlab, 
	using double arrays found in the workspace, and loaded directly into memory.
*/


#include "./AverageFilter.h"

void mexFunction( int nlhs, mxArray* plhs[],
				  int nrhs, const mxArray* prhs[])
{

	int i,j,noerr;

	/* required input: */
	double* imagein=NULL;
	int     imagein_rows,imagein_cols;
	int     smooth;


	/* output: */
	mxArray* pfield=NULL;
	double* imageout=NULL;
	int     imageout_rows,imageout_cols;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&AverageFilterUsage);

	/*Fetch data: */
	FetchData(&imagein,&imagein_rows,&imagein_cols,IMAGEIN);
	FetchData(&smooth,SMOOTH);
	
	/*Run core hole filler routine: */
	AverageFilterx( &imageout,imagein,imagein_rows,imagein_cols,smooth);

	/* output: */
	WriteData(IMAGEOUT,imageout,imagein_rows,imagein_cols);

	/*end module: */
	MODULEEND();
}


void AverageFilterUsage(void)
{
	printf("   AverageFilter usage:\n");
	printf("   [image_out]=AverageFilter(image_in,pixels);\n\n");
	printf("   where:\n");
	printf("      image_in in double format\n");
	printf("      pixels: characteristic size of smoothing\n");
	printf("      image_out in double format\n");
	printf("\n");
}
