/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   i;
	BamgArgs bamgargs;
	BamgMesh bamgmesh;
	BamgGeom bamggeom;

	/*inputs: */
	char*   geomfile=NULL;
	int     NumVertices;
	double* Vertices=NULL;
	int     NumEdges;
	double* Edges=NULL;
	double* hVertices=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*process inputs*/
	FetchData(&geomfile,mxGetField(BAMGOPTIONS,0,"fgeom"));

	FetchData(&NumVertices,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	FetchData(&Vertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	FetchData(&NumEdges,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	FetchData(&Edges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	FetchData(&hVertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"hVertices"));

	/*create bamg geometry input*/
	bamggeom.NumVertices=NumVertices;
	bamggeom.Vertices=Vertices;
	bamggeom.NumEdges=NumEdges;
	bamggeom.Edges=Edges;
	bamggeom.hVertices=hVertices;
	bamggeom.Edges=Edges;
	bamggeom.MetricVertices=NULL;
	bamggeom.h1h2VpVertices=NULL;
	bamggeom.MaximalAngleOfCorner=10;
	bamggeom.NumTangentAtEdges=0;
	bamggeom.TangentAtEdges=NULL;
	bamggeom.NumCorners=0;
	bamggeom.Corners=NULL;
	bamggeom.NumRequiredVertices=0;
	bamggeom.RequiredVertices=NULL;
	bamggeom.NumRequiredEdges=0;
	bamggeom.RequiredEdges=NULL;
	bamggeom.NumSubDomain=0;
	bamggeom.SubDomain=NULL;

	/*create bamg mesh input*/
	bamgargs.geomfile=geomfile;

	/*create bamg mesh input*/

	/*!Generate internal degree of freedom numbers: */
	Bamgx(&bamgmesh,&bamggeom,&bamgargs);

	/*write output datasets: */
	WriteData(ELEMENTSOUT,bamgmesh.index,bamgmesh.numberofelements,3);
	WriteData(XOUT,bamgmesh.x,bamgmesh.numberofnodes);
	WriteData(YOUT,bamgmesh.y,bamgmesh.numberofnodes);

	/*Free ressources: */
	xfree((void**)&geomfile);
	xfree((void**)&Vertices);
	xfree((void**)&Edges);
	xfree((void**)&hVertices);

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,x,y]=%s(elements,x,y,metric,gradation,splitpbedge,nbv);\n",__FUNCT__);
	_printf_("\n");
}
