/*!\file ControlParam.c
 * \brief: implementation of the ControlParam object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "shared/shared.h"

/*ControlParam constructors and destructor*/
ControlParam::ControlParam(){/*{{{*/
	return;
}
/*}}}*/
ControlParam::ControlParam(IssmDouble* in_value, IssmDouble* in_minvalue, IssmDouble* in_maxvalue, IssmDouble* in_savedvalue, IssmDouble* in_gradient, int in_enum_type, int in_M){/*{{{*/

	M=in_M;

	if(M){
		value=xNew<IssmDouble>(M);
		xMemCpy<IssmDouble>(value,in_value,M);
		
		minvalue=xNew<IssmDouble>(M);
		xMemCpy<IssmDouble>(minvalue,in_minvalue,M);
		
		maxvalue=xNew<IssmDouble>(M);
		xMemCpy<IssmDouble>(maxvalue,in_maxvalue,M);
		
		savedvalue=NULL;
		gradient=NULL;
		
	}
	else{
		value=NULL;
		minvalue=NULL;
		maxvalue=NULL;
		savedvalue=NULL;
		gradient=NULL;
	}

	enum_type=in_enum_type;
}
/*}}}*/
ControlParam::ControlParam(IssmDouble* in_value, IssmDouble* in_minvalue, IssmDouble* in_maxvalue, int in_enum_type, int in_M){/*{{{*/

	enum_type=in_enum_type;
	M=in_M;

	if(M){
		value=xNew<IssmDouble>(M);
		xMemCpy<IssmDouble>(value,in_value,M);
		
		minvalue=xNew<IssmDouble>(M);
		xMemCpy<IssmDouble>(minvalue,in_minvalue,M);
		
		maxvalue=xNew<IssmDouble>(M);
		xMemCpy<IssmDouble>(maxvalue,in_maxvalue,M);
	
		savedvalue=NULL;
		gradient=NULL;
	}
	else{
		value=NULL;
		minvalue=NULL;
		maxvalue=NULL;
		savedvalue=NULL;
		gradient=NULL;
	}

}
/*}}}*/
ControlParam::~ControlParam(){/*{{{*/
	xDelete<IssmDouble>(value);
	xDelete<IssmDouble>(minvalue);
	xDelete<IssmDouble>(maxvalue);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
Param* ControlParam::copy() {/*{{{*/

	return new ControlParam(this->value,this->minvalue,this->maxvalue,this->savedvalue,this->gradient,this->enum_type,this->M);

}
/*}}}*/
void ControlParam::DeepEcho(void){/*{{{*/

	_printf_(setw(22)<<"   ControlParam "<<setw(35)<<left<<EnumToStringx(this->enum_type)<<"\n ");
	if (value) _printf_("---value: ");
	for(int i=0;i<this->M;i++) _printf_(" "<< this->value[i]);
	_printf_("]\n");
	if (savedvalue) _printf_("---savedvalue: " << this->savedvalue << "\n");
	if (minvalue) _printf_("---minvalue: ");
	for(int i=0;i<this->M;i++) _printf_(" "<< this->minvalue[i]);
	_printf_("]\n");
	if (maxvalue) _printf_("---maxvalue: ");
	for(int i=0;i<this->M;i++) _printf_(" "<< this->maxvalue[i]);
	_printf_("]\n");
	if (gradient) _printf_("---gradient: " << this->gradient << "\n");
}
/*}}}*/
void ControlParam::Echo(void){/*{{{*/
	this->DeepEcho();
}
/*}}}*/
int  ControlParam::Id(void){ return -1; }/*{{{*/
/*}}}*/
void ControlParam::Marshall(MarshallHandle* marshallhandle){ /*{{{*/

	int object_enum = ControlParamEnum;
   marshallhandle->call(object_enum);
	marshallhandle->call(this->enum_type);
	marshallhandle->call(this->M);
	marshallhandle->call(this->value,this->M);
	marshallhandle->call(this->minvalue,this->M);
	marshallhandle->call(this->maxvalue,this->M);
	marshallhandle->call(this->savedvalue,this->M);
	marshallhandle->call(this->gradient,this->M);

}
/*}}}*/
int  ControlParam::ObjectEnum(void){/*{{{*/

	return ControlParamEnum;

}
/*}}}*/

void  ControlParam::GetParameterValue(IssmDouble** poutput,int* pM, const char* data){/*{{{*/

	IssmDouble* output=xNew<IssmDouble>(M);
	
	if(strcmp(data,"value")==0){
		xMemCpy<IssmDouble>(output,value,M);
	}
	else if(strcmp(data,"savedvalues")==0){
		xMemCpy<IssmDouble>(output,savedvalue,M);
	}
	else if (strcmp(data,"lowerbound")==0){
		xMemCpy<IssmDouble>(output,minvalue,M);
	}
	else if (strcmp(data,"upperbound")==0){
		xMemCpy<IssmDouble>(output,maxvalue,M);
	}
	else if (strcmp(data,"gradient")==0){
		xMemCpy<IssmDouble>(output,gradient,M);
	}
	else{
		_error_("Data " << data << " not supported yet");
	}
	
	/*Assign output pointers:*/
	if(pM) *pM=M;
	*poutput=output;
}
/*}}}*/
void  ControlParam::GetParameterValue(IssmDouble* poutput){/*{{{*/

	xMemCpy<IssmDouble>(poutput,value,M);
	
}
/*}}}*/
void  ControlParam::GetParameterValue(IssmDouble* poutput, IssmDouble time){/*{{{*/

	_assert_(M==1);
	*poutput = value[0];

}
/*}}}*/
void  ControlParam::GetParameterValue(IssmDouble** poutput, int* pM){/*{{{*/

	IssmDouble* output=NULL;

	if(M){
		output=xNew<IssmDouble>(M);
		xMemCpy<IssmDouble>(output,value,M);
	}
	
	/*Assign output pointers:*/
	if(pM) *pM=M;
	*poutput=output;
	
}
/*}}}*/
void  ControlParam::SetValue(IssmDouble* poutput, int in_M){/*{{{*/

	/*avoid leak: */
	xDelete<IssmDouble>(this->value);
	
	this->value=xNew<IssmDouble>(in_M);
	xMemCpy<IssmDouble>(this->value,poutput,in_M);

	this->M=in_M;
}
/*}}}*/
void  ControlParam::SetGradient(IssmDouble* poutput, int in_M){/*{{{*/

	/*avoid leak: */
	xDelete<IssmDouble>(this->gradient);
	
	this->gradient=xNew<IssmDouble>(in_M);
	xMemCpy<IssmDouble>(this->gradient,poutput,in_M);

	this->M=in_M;
}
/*}}}*/
void  ControlParam::GetVectorFromControl(Vector<IssmDouble>* vector,int control_index,int N,const char* data,int offset){/*{{{*/

	/*Get list of ids for this element and this control*/
	_assert_(N==this->M); //FIXME
	int* idlist = xNew<int>(this->M);
	for(int i=0;i<this->M;i++) idlist[i] = offset+i;

	/*Get data*/
	IssmDouble* values = xNew<IssmDouble>(this->M);
	GetParameterValue(&values, NULL, data);

	/*Enter data in vector*/
	vector->SetValues(this->M,idlist,values,INS_VAL);

	/*Clean up*/
	xDelete<int>(idlist);
	xDelete<IssmDouble>(values);

}/*}}}*/
