function md=bamg(md,varargin)
%BAMG - mesh generation
%
%   Usage:
%      md=bamg(md,varargin);

%process options {{{1
options=pairoptions(varargin{:});

%initialize the structures required as input of Bamg
bamg_options=struct();
bamg_geometry=struct();

%fill out the geometry
bamg_geometry.Vertices=getfieldvalue(options,'Vertices',NaN);
bamg_geometry.NumVertices=size(bamg_geometry.Vertices,1);
bamg_geometry.Edges=getfieldvalue(options,'Edges',NaN);
bamg_geometry.NumEdges=size(bamg_geometry.Edges,1);
bamg_geometry.hVertices=getfieldvalue(options,'hVertices',NaN);

bamg_options.fgeom=getfieldvalueerr(options,'fgeom');
%}}}

%call Bamg
[elements,x,y]=Bamg(bamg_geometry,bamg_options);

% plug results onto model {{{1
md.x=x;
md.y=y;
md.elements=elements;

%Fill in rest of fields:
md.numberofelements=length(md.elements);
md.numberofgrids=length(md.x);
md.z=zeros(md.numberofgrids,1);
md.type='2d';
%}}}
