/*!\file Cfsurfacesquaretransient.cpp
 * \brief: Cfsurfacesquaretransient Object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./classes.h"
#include "./ExternalResults/ExternalResult.h"
#include "./ExternalResults/Results.h"
#include "../datastructures/datastructures.h"
#include "./Elements/Element.h"
#include "./Elements/Elements.h"
#include "./FemModel.h"
#include "../modules/SurfaceAreax/SurfaceAreax.h"
#include "../classes/Params/Parameters.h"
#include "../classes/gauss/Gauss.h"
#include "./Inputs/DatasetInput.h"
/*}}}*/

/*Cfsurfacesquaretransient constructors, destructors :*/
Cfsurfacesquaretransient::Cfsurfacesquaretransient(){/*{{{*/

	this->definitionenum = -1;
	this->name           = NULL;
	this->model_enum     = UNDEF;
	this->datatimes      = NULL;
	this->passedflags    = NULL;
}
/*}}}*/
Cfsurfacesquaretransient::Cfsurfacesquaretransient(char* in_name, int in_definitionenum, int in_model_enum, int in_num_datatimes, IssmDouble* in_datatimes, bool* in_passedflags){/*{{{*/

	this->definitionenum=in_definitionenum;

	this->name = xNew<char>(strlen(in_name)+1);
	xMemCpy<char>(this->name,in_name,strlen(in_name)+1);

	this->model_enum=in_model_enum;
	this->num_datatimes = in_num_datatimes;

	/*Allocate arrays*/
	_assert_(this->num_datatimes>0);
	this->datatimes   = xNew<IssmDouble>(this->num_datatimes);
	this->passedflags = xNew<bool>(this->num_datatimes);
	xMemCpy<IssmDouble>(this->datatimes,in_datatimes,this->num_datatimes);
	xMemCpy<bool>(this->passedflags,in_passedflags,this->num_datatimes);
}
/*}}}*/
Cfsurfacesquaretransient::Cfsurfacesquaretransient(char* in_name, int in_definitionenum, int in_model_enum, int in_num_datatimes, IssmDouble* in_datatimes){/*{{{*/

	this->definitionenum=in_definitionenum;

	this->name = xNew<char>(strlen(in_name)+1);
	xMemCpy<char>(this->name,in_name,strlen(in_name)+1);

	this->model_enum=in_model_enum;
	this->num_datatimes = in_num_datatimes;

	/*Allocate arrays*/
	_assert_(this->num_datatimes>0);
	this->datatimes   = xNew<IssmDouble>(this->num_datatimes);
	this->passedflags = xNew<bool>(this->num_datatimes);
	xMemCpy<IssmDouble>(this->datatimes,in_datatimes,this->num_datatimes);

	/*initialize passedtimes to false*/
	for(int i=0;i<this->num_datatimes;i++) this->passedflags[i]= false;
}
/*}}}*/
Cfsurfacesquaretransient::~Cfsurfacesquaretransient(){/*{{{*/
	if(this->name) xDelete(this->name);
	if(this->datatimes) xDelete(this->datatimes);
	if(this->passedflags) xDelete(this->passedflags);
}
/*}}}*/

/*Object virtual function resolutoin: */
Object* Cfsurfacesquaretransient::copy() {/*{{{*/
	Cfsurfacesquaretransient* output = new Cfsurfacesquaretransient(this->name,this->definitionenum, this->model_enum, this->num_datatimes, this->datatimes,this->passedflags);
	return (Object*)output;
}
/*}}}*/
void Cfsurfacesquaretransient::DeepEcho(void){/*{{{*/
	this->Echo();
}
/*}}}*/
void Cfsurfacesquaretransient::Echo(void){/*{{{*/
	_printf_(" Cfsurfacesquaretransient: " << name << " " << this->definitionenum << "\n");
	_printf_("    model_enum: " << model_enum << " " << EnumToStringx(model_enum) << "\n");
	_error_("not implemented yet");
}
/*}}}*/
int Cfsurfacesquaretransient::Id(void){/*{{{*/
	return -1;
}
/*}}}*/
void Cfsurfacesquaretransient::Marshall(MarshallHandle* marshallhandle){/*{{{*/

	int object_enum=CfsurfacesquaretransientEnum;
	marshallhandle->call(object_enum);

	marshallhandle->call(this->definitionenum);
	marshallhandle->call(this->model_enum);
	marshallhandle->call(this->name);
	marshallhandle->call(this->num_datatimes);
	marshallhandle->call(this->datatimes,this->num_datatimes);
	marshallhandle->call(this->passedflags,this->num_datatimes);
} 
/*}}}*/
int Cfsurfacesquaretransient::ObjectEnum(void){/*{{{*/
	return CfsurfacesquaretransientEnum;
}
/*}}}*/

/*Definition virtual function resolutoin: */
int Cfsurfacesquaretransient::DefinitionEnum(){/*{{{*/
	return this->definitionenum;
}
/*}}}*/
char* Cfsurfacesquaretransient::Name(){/*{{{*/
	char* name2=xNew<char>(strlen(this->name)+1);
	xMemCpy(name2,this->name,strlen(this->name)+1);

	return name2;
}
/*}}}*/
IssmDouble Cfsurfacesquaretransient::Response(FemModel* femmodel){/*{{{*/
	 _error_("Not implemented yet");

}
/*}}}*/
IssmDouble Cfsurfacesquaretransient::Cfsurfacesquaretransient_Calculation(Element* element, int model_enum){/*{{{*/

	_error_("not implemented");
}/*}}}*/
