/*!\file Cfrheologybbarabsgrad.h
 * \brief: header file for Cfrheologybbarabsgrad object
 */

#ifndef _CFRHEOLOGYBBARABSGRAD_H_
#define _CFRHEOLOGYBBARABSGRAD_H_

/*Headers:*/
#include "./Definition.h"
#include "./FemModel.h"

IssmDouble OutputDefinitionsResponsex(FemModel* femmodel,int output_enum);
void  GetVectorFromInputsx( IssmDouble** pvector, int* pvector_size, FemModel* femmodel,int name);

class Cfrheologybbarabsgrad: public Object, public Definition{

	public: 

		int         definitionenum;
		char*       name;
		int         weights_enum;
		bool			timepassedflag;

		IssmDouble  misfit; //value carried over in time.

		/*Cfrheologybbarabsgrad constructors, destructors :*/
		Cfrheologybbarabsgrad();
		Cfrheologybbarabsgrad(char* in_name, int in_definitionenum, int in_weights_enum,  bool timepassedflag);
		~Cfrheologybbarabsgrad();

		/*Object virtual function resolutoin: */
		Object* copy();
		void DeepEcho(void);
		void Echo(void);
		int Id(void);
		void Marshall(MarshallHandle* marshallhandle);
		int ObjectEnum(void);

		/*Definition virtual function resolutoin: */
		int DefinitionEnum();
		char* Name();
		IssmDouble Response(FemModel* femmodel);
		IssmDouble Cfrheologybbarabsgrad_Calculation(Element* element, int weights_enum);
};
#endif  /* _CFRHEOLOGYBBARABSGRAD_H_ */
