function md=diagnostic_proto(md);
%DIAGNOSTIC - compute the velocity field of a model
%   Usage:
%      md=diagnostic(md)
%

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	md.analysis_type='diagnostic_horiz'; m_dh=CreateFemModel(md);
	md.analysis_type='diagnostic_vert'; m_dv=CreateFemModel(md);
	md.analysis_type='diagnostic_stokes'; m_ds=CreateFemModel(md);
	md.analysis_type='diagnostic_hutter'; m_dhu=CreateFemModel(md);
	md.analysis_type='surface_slope_compute'; m_ss=CreateFemModel(md);
	md.analysis_type='bed_slope_compute'; m_bs=CreateFemModel(md);
	
	% figure out number of dof: just for information purposes.
	md.dof=m_dh.nodesets.fsize; %biggest dof number

	%initialize inputs
	inputs=inputlist;
	inputs=add(inputs,'velocity',m_dh.parameters.u_g,'doublevec',3,m_dh.parameters.numberofnodes);

	%compute solution
	[u_g,pg]=diagnostic_core(m_dh,m_dhu,m_dv,m_ds,m_ss,m_bs,inputs);

	%Load results onto model
	md=loadresults(md,u_g,p_g,m_dh,m_ds,m_dhu);

	%stop timing
	t2=clock;
	disp(sprintf('\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']));
