function colorbar_rgb=buildoverlaycolorbar(md,data,transparency);
%BUILDOVERLAYCOLORBAR - creates the colorbar associated with an averlay plot option
%
%   creates a color bar assotiated with the RGB image created be BUILDOVERLAY
%   that uses RGB colors
%
%   Usage:
%      colorbar_rgb=buildoverlaycolorbar(md,data,transparency);
%
%   Example:
%      colorbar_rgb=buildoverlaycolorbar(md,md.vel,0.5);
%
%   See also: RADARPOWER, PLOTMODEL, BUILDOVERLAY

%recover results
results=max(1.5,min(data)):(max(data)-min(data))/256:max(data);

%Build hsv color image from radar and results
%intensity
v=ones(size(results,1),1);

%hue
%cut results under 1.5, and log
%results(find(results<1.5))=1.5;
h=bytscl(results)/(255+1); %1 offset on colormap

%saturation
s=(0.5+results/125)/transparency;s(find(s>1))=1;s(find(s<0))=0;
s(find(results==1.5))=0;

%Transform hsv to rgb
colorbar_hsv=zeros(size(results,2),size(results,1),3);
colorbar_hsv(:,:,1)=h;
colorbar_hsv(:,:,2)=s;
colorbar_hsv(:,:,3)=v;

%Transform rgb to hsv
colorbar_rgb=hsv2rgb(colorbar_hsv);
