/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	ParametersSTARTEnum,
	/*Parameters{{{*/
	AdolcParamEnum,
	AgeStabilizationEnum,
	AgeNumRequestedOutputsEnum,
	AgeRequestedOutputsEnum,
	AmrDeviatoricErrorGroupThresholdEnum,
	AmrDeviatoricErrorMaximumEnum,
	AmrDeviatoricErrorResolutionEnum,
	AmrDeviatoricErrorThresholdEnum,
	AmrErrEnum,
	AmrFieldEnum,
	AmrGradationEnum,
	AmrGroundingLineDistanceEnum,
	AmrGroundingLineResolutionEnum,
	AmrHmaxEnum,
	AmrHminEnum,
	AmrIceFrontDistanceEnum,
	AmrIceFrontResolutionEnum,
	AmrKeepMetricEnum,
	AmrLagEnum,
	AmrLevelMaxEnum,
	AmrRestartEnum,
	AmrThicknessErrorGroupThresholdEnum,
	AmrThicknessErrorMaximumEnum,
	AmrThicknessErrorResolutionEnum,
	AmrThicknessErrorThresholdEnum,
	AmrTypeEnum,
	AnalysisCounterEnum,
	AnalysisTypeEnum,
	AugmentedLagrangianREnum,
	AugmentedLagrangianRholambdaEnum,
	AugmentedLagrangianRhopEnum,
	AugmentedLagrangianRlambdaEnum,
	AugmentedLagrangianThetaEnum,
	AutodiffCbufsizeEnum,
	AutodiffDependentObjectsEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffGcTriggerMaxSizeEnum,
	AutodiffGcTriggerRatioEnum,
	AutodiffIsautodiffEnum,
	AutodiffLbufsizeEnum,
	AutodiffNumDependentsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffObufsizeEnum,
	AutodiffTapeAllocEnum,
	AutodiffTbufsizeEnum,
	AutodiffXpEnum,
	BalancethicknessStabilizationEnum,
	BarystaticContributionsEnum,
	BasalforcingsARMATimestepEnum,
	BasalforcingsARMAarOrderEnum,
	BasalforcingsARMAmaOrderEnum,
	BasalforcingsBottomplumedepthEnum,
	BasalforcingsCrustthicknessEnum,
	BasalforcingsDeepwaterElevationEnum,
	BasalforcingsDeepwaterMeltingRateEnum,
	BasalforcingsDtbgEnum,
	BasalforcingsEnum,
	BasalforcingsIsmip6AverageTfEnum,
	BasalforcingsIsmip6BasinAreaEnum,
	BasalforcingsIsmip6DeltaTEnum,
	BasalforcingsIsmip6Gamma0Enum,
	BasalforcingsIsmip6IsLocalEnum,
	BasalforcingsIsmip6NumBasinsEnum,
	BasalforcingsIsmip6TfDepthsEnum,
	BasalforcingsLinearNumBasinsEnum,
	BasalforcingsLinearNumBreaksEnum,
	BasalforcingsLinearNumParamsEnum,
	BasalforcingsMantleconductivityEnum,
	BasalforcingsNusseltEnum,
	BasalforcingsARMAarlagcoefsEnum,
	BasalforcingsARMAdatebreaksEnum,
	BasalforcingsARMAmalagcoefsEnum,
	BasalforcingsARMApolyparamsEnum,
	BasalforcingsIsThermalForcingEnum,
	BasalforcingsLowercrustheatEnum,
	BasalforcingsPicoAverageOverturningEnum,
	BasalforcingsPicoAverageSalinityEnum,
	BasalforcingsPicoAverageTemperatureEnum,
	BasalforcingsPicoBoxAreaEnum,
	BasalforcingsPicoFarOceansalinityEnum,
	BasalforcingsPicoFarOceantemperatureEnum,
	BasalforcingsPicoGammaTEnum,
	BasalforcingsPicoIsplumeEnum,
	BasalforcingsPicoMaxboxcountEnum,
	BasalforcingsPicoNumBasinsEnum,
	BasalforcingsPlumeradiusEnum,
	BasalforcingsPlumexEnum,
	BasalforcingsPlumeyEnum,
	BasalforcingsThresholdThicknessEnum,
	BasalforcingsTopplumedepthEnum,
	BasalforcingsUppercrustheatEnum,
	BasalforcingsUppercrustthicknessEnum,
	BasalforcingsUpperdepthMeltEnum,
	BasalforcingsUpperwaterElevationEnum,
	BasalforcingsUpperwaterMeltingRateEnum,
	CalvingCrevasseDepthEnum,
	CalvingCrevasseThresholdEnum,
	CalvingHeightAboveFloatationEnum,
	CalvingLawEnum,
	CalvingMinthicknessEnum,
	CalvingTestSpeedfactorEnum,
	CalvingTestIndependentRateEnum,
	CalvingUseParamEnum,
	CalvingThetaEnum,
	CalvingAlphaEnum,
	CalvingXoffsetEnum,
	CalvingYoffsetEnum,
	CalvingVelLowerboundEnum,
	CalvingVelMaxEnum,
	CalvingVelThresholdEnum,
	CalvingVelUpperboundEnum,
	CalvingRcEnum,
	ConfigurationTypeEnum,
	ConstantsGEnum,
	ConstantsNewtonGravityEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	ControlInputSizeMEnum,
	ControlInputSizeNEnum,
	ControlInputInterpolationEnum,
	CumBslcEnum,
	CumBslcIceEnum,
	CumBslcHydroEnum,
	CumBslcOceanEnum,
	CumBslcIcePartitionEnum,
	CumBslcHydroPartitionEnum,
	CumBslcOceanPartitionEnum,
	CumGmtslcEnum,
	CumGmslcEnum,
	DamageC1Enum,
	DamageC2Enum,
	DamageC3Enum,
	DamageC4Enum,
	DamageEnum,
	DamageEquivStressEnum,
	DamageEvolutionNumRequestedOutputsEnum,
	DamageEvolutionRequestedOutputsEnum,
	DamageHealingEnum,
	DamageKappaEnum,
	DamageLawEnum,
	DamageMaxDamageEnum,
	DamageStabilizationEnum,
	DamageStressThresholdEnum,
	DamageStressUBoundEnum,
	DebrisMinThicknessEnum,
	DebrisNumRequestedOutputsEnum,
	DebrisPenaltyFactorEnum,
	DebrisRequestedOutputsEnum,
	DebrisStabilizationEnum,
	DebrisRemovalmodelEnum,
	DebrisDisplacementmodelEnum,
	DebrisRemovalSlopeThresholdEnum,
	DebrisRemovalStressThresholdEnum,
	DebrisPackingFractionEnum,
	DebugProfilingEnum,
	DomainDimensionEnum,
	DomainTypeEnum,
	DslModelEnum,
	DslModelidEnum,
	DslNummodelsEnum,
	SolidearthIsExternalEnum,
	SolidearthExternalNatureEnum,
	SolidearthExternalModelidEnum,
	SolidearthExternalNummodelsEnum,
	SolidearthSettingsComputeBpGrdEnum,
	EarthIdEnum,
	ElasticEnum,
	EplZigZagCounterEnum,
	EsaHElasticEnum,
	EsaHemisphereEnum,
	EsaRequestedOutputsEnum,
	EsaUElasticEnum,
	ExtrapolationVariableEnum,
	FemModelCommEnum,
	FieldsEnum,
	FlowequationFeFSEnum,
	FlowequationIsFSEnum,
	FlowequationIsHOEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsMOLHOEnum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FlowequationIsNitscheEnum,
	FeFSNitscheGammaEnum,
	FrictionCouplingEnum,
	FrictionDeltaEnum,
	FrictionEffectivePressureLimitEnum,
	FrictionFEnum,
	FrictionGammaEnum,
	FrictionLawEnum,
	FrictionLinearizeEnum,
	FrictionPseudoplasticityExponentEnum,
	FrictionU0Enum,
	FrictionThresholdSpeedEnum,
	FrictionVoidRatioEnum,
	FrontalForcingsBasinIcefrontAreaEnum,
   FrontalForcingsARMATimestepEnum,
   FrontalForcingsARMAarOrderEnum,
   FrontalForcingsARMAmaOrderEnum,
   FrontalForcingsARMAdatebreaksEnum,
	FrontalForcingsARMAmonthdatebreaksEnum,
   FrontalForcingsARMAmonthinterceptsEnum,
   FrontalForcingsARMAmonthtrendsEnum,
   FrontalForcingsARMApolyparamsEnum,
	FrontalForcingsIsDischargeARMAEnum,
	FrontalForcingsNumberofBasinsEnum,
	FrontalForcingsNumberofBreaksEnum,
	FrontalForcingsNumberofMonthBreaksEnum,
	FrontalForcingsNumberofParamsEnum,
	FrontalForcingsParamEnum,
   FrontalForcingsARMAarlagcoefsEnum,
   FrontalForcingsARMAmalagcoefsEnum,
   FrontalForcingsSdarlagcoefsEnum,
	FrontalForcingsSdARMATimestepEnum,
   FrontalForcingsSdarOrderEnum,
   FrontalForcingsSddatebreaksEnum,
   FrontalForcingsSdmalagcoefsEnum,
   FrontalForcingsSdmaOrderEnum,
   FrontalForcingsSdMonthlyFracEnum,
	FrontalForcingsSdNumberofBreaksEnum,
	FrontalForcingsSdNumberofParamsEnum,
   FrontalForcingsSdpolyparamsEnum,
	GrdModelEnum,
	GroundinglineFrictionInterpolationEnum,
	GroundinglineMeltInterpolationEnum,
	GroundinglineMigrationEnum,
	GroundinglineNumRequestedOutputsEnum,
	GroundinglineRequestedOutputsEnum,
	HydrologyarmaarOrderEnum,
   HydrologyarmaarlagcoefsEnum,
   HydrologyarmadatebreaksEnum,
   HydrologyarmamalagcoefsEnum,
   HydrologyarmamaOrderEnum,
   HydrologyarmaMonthlyFactorsEnum,
   HydrologyarmaNumBreaksEnum,
   HydrologyarmaNumParamsEnum,
   HydrologyarmapolyparamsEnum,
   HydrologyarmaTimestepEnum,
	HydrologyAveragingEnum,
	HydrologyCavitySpacingEnum,	
	HydrologyChannelSheetWidthEnum,
	HydrologyEnglacialVoidRatioEnum,
	HydrologyIschannelsEnum,
	HydrologyIsWaterPressureArmaEnum,
	HydrologyMeltFlagEnum,
	HydrologyModelEnum,
	HydrologyNumBasinsEnum,
	HydrologyNumRequestedOutputsEnum,
	HydrologyPressureMeltCoefficientEnum,
	HydrologyRelaxationEnum,
	HydrologyRequestedOutputsEnum,
	HydrologySedimentKmaxEnum,
	HydrologyStepsPerStepEnum,
	HydrologyStorageEnum,
	HydrologydcEplColapseThicknessEnum,
	HydrologydcEplConductivityEnum,
	HydrologydcEplInitialThicknessEnum,
	HydrologydcEplLayerCompressibilityEnum,
	HydrologydcEplMaxThicknessEnum,
	HydrologydcEplPoreWaterMassEnum,
	HydrologydcEplThickCompEnum,
	HydrologydcEplflipLockEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcMaxIterEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologydcPenaltyLockEnum,
	HydrologydcRelTolEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentLayerCompressibilityEnum,
	HydrologydcSedimentPoreWaterMassEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologyStepAdaptEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcUnconfinedFlagEnum,
	HydrologyshreveStabilizationEnum,
	IcecapToEarthCommEnum,
	IndexEnum,
	InputFileNameEnum,
	DirectoryNameEnum,
	IndicesEnum,
	InputToDepthaverageInEnum,
	InputToDepthaverageOutEnum,
	InputToExtrudeEnum,
	InputToL2ProjectEnum,
	InputToSmoothEnum,
	InversionAlgorithmEnum,
	InversionControlParametersEnum,
	InversionControlScalingFactorsEnum,
	InversionCostFunctionsEnum,
	InversionDxminEnum,
	InversionGatolEnum,
	InversionGradientScalingEnum,
	InversionGrtolEnum,
	InversionGttolEnum,
	InversionIncompleteAdjointEnum,
	InversionIscontrolEnum,
	InversionMaxiterEnum,
	InversionMaxiterPerStepEnum,
	InversionMaxstepsEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionStopFlagEnum,
	InversionTypeEnum,
	IvinsEnum,
	IsSlcCouplingEnum,
	LevelsetKillIcebergsEnum,
	LevelsetReinitFrequencyEnum,
	LevelsetStabilizationEnum,
	LockFileNameEnum,
	LoveAllowLayerDeletionEnum,
	LoveChandlerWobbleEnum,
	LoveCoreMantleBoundaryEnum,
	LoveEarthMassEnum,
	LoveForcingTypeEnum,
	LoveFrequenciesEnum,
	LoveIsTemporalEnum,
	LoveG0Enum,
	LoveGravitationalConstantEnum,
	LoveInnerCoreBoundaryEnum,
	LoveComplexComputationEnum,
	LoveQuadPrecisionEnum,
	LoveIntStepsPerLayerEnum,
	LoveMinIntegrationStepsEnum,
	LoveMaxIntegrationdrEnum,
	LoveIntegrationSchemeEnum,
	LoveKernelsEnum,
	LoveMu0Enum,
	LoveNfreqEnum,
	LoveNTemporalIterationsEnum,
	LoveNYiEquationsEnum,
	LoveR0Enum,
	LoveShNmaxEnum,
	LoveShNminEnum,
	LoveStartingLayerEnum,
	LoveUnderflowTolEnum,
	LovePostWidderThresholdEnum,
	LoveDebugEnum,
	LoveHypergeomNZEnum,
	LoveHypergeomNAlphaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportRequestedOutputsEnum,
	MasstransportStabilizationEnum,
	MaterialsBetaEnum,
	MaterialsEarthDensityEnum,
	MaterialsEffectiveconductivityAveragingEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsMuWaterEnum,
	MaterialsRheologyLawEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoSeawaterEnum,
	MaterialsTemperateiceconductivityEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MeltingOffsetEnum,
	MeshAverageVertexConnectivityEnum,
	MeshElementtypeEnum,
	MeshNumberoflayersEnum,
	MeshNumberofverticesEnum,
	MeshNumberofelementsEnum,
	MigrationMaxEnum,
	ModelIdEnum,
	NbinsEnum,
	NodesEnum,
	NumModelsEnum,
	OceanGridNxEnum,
	OceanGridNyEnum,
	OceanGridXEnum,
	OceanGridYEnum,
	OutputBufferPointerEnum,
	OutputBufferSizePointerEnum,
	OutputFileNameEnum,
	OutputFilePointerEnum,
	OutputdefinitionEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuIsdakotaEnum,
	QmuOutNameEnum,
	QmuOutputEnum,
	QmuCurrEvalIdEnum,
	QmuNsampleEnum,
	QmuResponsedescriptorsEnum,
	QmuVariableDescriptorsEnum,
	QmuVariablePartitionsEnum,
	QmuVariablePartitionsNpartEnum,
	QmuVariablePartitionsNtEnum,
	QmuResponsePartitionsEnum,
	QmuResponsePartitionsNpartEnum,
	QmuStatisticsEnum,
	QmuNumstatisticsEnum,
	QmuNdirectoriesEnum,
	QmuNfilesPerDirectoryEnum,
	QmuStatisticsMethodEnum,
	QmuMethodsEnum,
	RestartFileNameEnum,
	ResultsEnum,
	RootPathEnum,
	ModelnameEnum,
	SamplingAlphaEnum,
	SamplingNumRequestedOutputsEnum,
	SamplingRequestedOutputsEnum,
	SamplingRobinEnum,
	SamplingSeedEnum,
	SaveResultsEnum,
	SolidearthPartitionIceEnum,
	SolidearthPartitionHydroEnum,
	SolidearthPartitionOceanEnum,
	SolidearthNpartIceEnum,
	SolidearthNpartOceanEnum,
	SolidearthNpartHydroEnum,
	SolidearthPlanetRadiusEnum,
	SolidearthPlanetAreaEnum,
	SolidearthSettingsAbstolEnum,
	SolidearthSettingsCrossSectionShapeEnum,
	SolidearthSettingsElasticEnum,
	SolidearthSettingsViscousEnum,
	SolidearthSettingsSatelliteGraviEnum,
	SolidearthSettingsDegreeAccuracyEnum,
	SealevelchangeGeometryDoneEnum,
	SealevelchangeViscousNumStepsEnum,
	SealevelchangeViscousTimesEnum,
	SealevelchangeViscousIndexEnum,
	SealevelchangeViscousPolarMotionEnum,
	SealevelchangeRunCountEnum,
	SealevelchangeTransitionsEnum,
	SealevelchangeRequestedOutputsEnum,
	RotationalAngularVelocityEnum,
	RotationalEquatorialMoiEnum,
	RotationalPolarMoiEnum,
	LovePolarMotionTransferFunctionColinearEnum,
	LovePolarMotionTransferFunctionOrthogonalEnum,
	TidalLoveHEnum,
	TidalLoveKEnum,
	TidalLoveLEnum,
	TidalLoveK2SecularEnum,
	LoadLoveHEnum,
	LoadLoveKEnum,
	LoadLoveLEnum,
	LoveTimeFreqEnum,
	LoveIsTimeEnum,
	LoveHypergeomZEnum,
	LoveHypergeomTable1Enum,
	LoveHypergeomTable2Enum,
	SealevelchangeGSelfAttractionEnum,
	SealevelchangeGViscoElasticEnum,
	SealevelchangeUViscoElasticEnum,
	SealevelchangeHViscoElasticEnum,
	SealevelchangePolarMotionTransferFunctionColinearEnum,
	SealevelchangePolarMotionTransferFunctionOrthogonalEnum,
	SealevelchangePolarMotionTransferFunctionZEnum,
	SealevelchangeTidalK2Enum,
	SealevelchangeTidalH2Enum,
	SealevelchangeTidalL2Enum,
	SolidearthSettingsSealevelLoadingEnum,
	SolidearthSettingsGRDEnum,
	SolidearthSettingsRunFrequencyEnum,
	SolidearthSettingsTimeAccEnum,
	SolidearthSettingsHorizEnum,
	SolidearthSettingsMaxiterEnum,
	SolidearthSettingsGrdOceanEnum,
	SolidearthSettingsOceanAreaScalingEnum,
	StochasticForcingCovarianceEnum,
	StochasticForcingDefaultDimensionEnum,
	StochasticForcingDimensionsEnum,
	StochasticForcingFieldsEnum,
	StochasticForcingIsEffectivePressureEnum,
	StochasticForcingIsStochasticForcingEnum,
	StochasticForcingIsWaterPressureEnum,
	StochasticForcingNoisetermsEnum,
	StochasticForcingNumFieldsEnum,
	StochasticForcingRandomflagEnum,
	StochasticForcingTimestepEnum,
	SolidearthSettingsReltolEnum,
	SolidearthSettingsSelfAttractionEnum,
	SolidearthSettingsRotationEnum,
	SolidearthSettingsMaxSHCoeffEnum,
	SettingsIoGatherEnum,
	SettingsNumResultsOnNodesEnum,
	SettingsOutputFrequencyEnum,
	SettingsCheckpointFrequencyEnum,
	SettingsResultsOnNodesEnum,
	SettingsSbCouplingFrequencyEnum,
	SettingsSolverResidueThresholdEnum,
	SettingsWaitonlockEnum,
	SmbAIceEnum,
	SmbAIdxEnum,
	SmbASnowEnum,
	SmbAccualtiEnum,
	SmbAccugradEnum,
	SmbAccurefEnum,
	SmbAdThreshEnum,
	SmbAlbedoSchemeEnum,
	SmbAlbedoSnowMaxEnum,
	SmbAlbedoSnowMinEnum,
	SmbAlbedoIceEnum,
	SmbAlbedoLandEnum,
	SmbARMATimestepEnum,
   SmbARMAarOrderEnum,
   SmbARMAmaOrderEnum,
	SmbAveragingEnum,
	SmbDesfacEnum,
	SmbDesfacElevEnum,
	SmbDpermilEnum,
	SmbDsnowIdxEnum,
   SmbElevationBinsEnum,
	SmbCldFracEnum,
	SmbDelta18oEnum,
	SmbDelta18oSurfaceEnum,
	SmbDenIdxEnum,
	SmbDtEnum,
	SmbEnum,
	SmbEIdxEnum,
	SmbFEnum,
	SmbInitDensityScalingEnum,
	SmbIsaccumulationEnum,
	SmbIsalbedoEnum,
	SmbIsconstrainsurfaceTEnum,
	SmbIsd18opdEnum,
	SmbIsdelta18oEnum,
	SmbIsdensificationEnum,
	SmbIsdeltaLWupEnum,
	SmbIsfirnwarmingEnum,
	SmbIsgraingrowthEnum,
	SmbIsmeltEnum,
	SmbIsmungsmEnum,
	SmbIsprecipscaledEnum,
	SmbIssetpddfacEnum,
	SmbIsshortwaveEnum,
	SmbIstemperaturescaledEnum,
	SmbIsthermalEnum,
	SmbIsturbulentfluxEnum,
	SmbKEnum,
   SmbLapseRatesEnum,
	SmbNumBasinsEnum,
	SmbNumBreaksEnum,
	SmbNumElevationBinsEnum,
	SmbNumParamsEnum,
	SmbNumRequestedOutputsEnum,
	SmbPfacEnum,
	SmbARMAarlagcoefsEnum,
	SmbARMAdatebreaksEnum,
	SmbARMAmalagcoefsEnum,
	SmbARMApolyparamsEnum,
	SmbRdlEnum,
	SmbRefElevationEnum,
	SmbRequestedOutputsEnum,
	SmbRlapsEnum,
	SmbRlapslgmEnum,
	SmbRunoffaltiEnum,
	SmbRunoffgradEnum,
	SmbRunoffrefEnum,
	SmbSealevEnum,
	SmbSemicMethodEnum,
	SmbSemicHcritEnum,
	SmbSemicRcritEnum,
	SmbStepsPerStepEnum,
	SmbSwIdxEnum,
	SmbT0dryEnum,
	SmbT0wetEnum,
	SmbTcIdxEnum,
	SmbTeThreshEnum,
	SmbTdiffEnum,
	SmbThermoDeltaTScalingEnum,
	SmbTemperaturesReconstructedYearsEnum,
	SmbPrecipitationsReconstructedYearsEnum,
	SmoothThicknessMultiplierEnum,
	SolutionTypeEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	StepEnum,
	StepsEnum,
	StressbalanceAbstolEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReltolEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
   ThermalForcingMonthlyEffectsEnum,
	ThermalIsdrainicecolumnEnum,
	ThermalIsdynamicbasalspcEnum,
	ThermalIsenthalpyEnum,
	ThermalMaxiterEnum,
	ThermalNumRequestedOutputsEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalReltolEnum,
	ThermalRequestedOutputsEnum,
	ThermalStabilizationEnum,
	ThermalWatercolumnUpperlimitEnum,
	TimeEnum,
	TimesteppingAverageForcingEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingCouplingTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingInterpForcingEnum,
	TimesteppingCycleForcingEnum,
	TimesteppingStartTimeEnum,
	TimesteppingTimeStepEnum,
	TimesteppingTimeStepMaxEnum,
	TimesteppingTimeStepMinEnum,
	TimesteppingTypeEnum,
	ToMITgcmCommEnum,
	ToolkitsFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	ToolkitsTypesEnum,
	TransientAmrFrequencyEnum,
	TransientIsageEnum,
	TransientIsdamageevolutionEnum,
	TransientIsdebrisEnum,
	TransientIsesaEnum,
	TransientIsgiaEnum,
	TransientIsgroundinglineEnum,
	TransientIshydrologyEnum,
	TransientIsmasstransportEnum,
	TransientIsoceantransportEnum,
	TransientIsmovingfrontEnum,
	TransientIsoceancouplingEnum,
	TransientIssamplingEnum,
	TransientIsslcEnum,
	TransientIssmbEnum,
	TransientIsstressbalanceEnum,
	TransientIsthermalEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	VelocityEnum,
	XxeEnum,
	YyeEnum,
	ZzeEnum,
	AreaeEnum,
	WorldCommEnum,
	/*}}}*/
	ParametersENDEnum,
	InputsSTARTEnum,
	/*Inputs{{{*/
	AccumulatedDeltaBottomPressureEnum,
	AccumulatedDeltaIceThicknessEnum,
	AccumulatedDeltaTwsEnum,
	AdjointEnum,
	AdjointpEnum,
	AdjointxEnum,
	AdjointxBaseEnum,
	AdjointxShearEnum,
	AdjointyEnum,
	AdjointyBaseEnum,
	AdjointyShearEnum,
	AdjointzEnum,
	AgeEnum,
	AirEnum,
	ApproximationEnum,
	BalancethicknessMisfitEnum,
	BalancethicknessOmega0Enum,
	BalancethicknessOmegaEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessThickeningRateEnum,
	BasalCrevasseEnum,
	BasalforcingsDeepwaterMeltingRatearmaEnum,
	BasalforcingsDeepwaterMeltingRateNoiseEnum,
	BasalforcingsDeepwaterMeltingRateValuesAutoregressionEnum,
	BasalforcingsDeepwaterMeltingRateValuesMovingaverageEnum,
	BasalforcingsFloatingiceMeltingRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsGroundediceMeltingRateEnum,
	BasalforcingsLinearBasinIdEnum,
	BasalforcingsPerturbationMeltingRateEnum,
	BasalforcingsSpatialDeepwaterElevationEnum,
	BasalforcingsSpatialDeepwaterMeltingRateEnum,
	BasalforcingsSpatialUpperwaterElevationEnum,
	BasalforcingsSpatialUpperwaterMeltingRateEnum,
	BasalforcingsIsmip6BasinIdEnum,
	BasalforcingsIsmip6TfEnum,
	BasalforcingsIsmip6TfShelfEnum,
	BasalforcingsIsmip6MeltAnomalyEnum,
	BasalforcingsMeltrateFactorEnum,
	BasalforcingsOceanSalinityEnum,
	BasalforcingsOceanTempEnum,
	BasalforcingsPicoBasinIdEnum,
	BasalforcingsPicoBoxIdEnum,
	BasalforcingsPicoOverturningCoeffEnum,
	BasalforcingsPicoSubShelfOceanOverturningEnum,
	BasalforcingsPicoSubShelfOceanSalinityEnum,
	BasalforcingsPicoSubShelfOceanTempEnum,
	BasalStressxEnum,
	BasalStressyEnum,
	BasalStressEnum,
	BaseEnum,
	BaseOldEnum,
	BaseSlopeXEnum,
	BaseSlopeYEnum,
	BaselineBasalforcingsFloatingiceMeltingRateEnum,
	BaselineBasalforcingsSpatialDeepwaterMeltingRateEnum,
	BaselineCalvingCalvingrateEnum,
	BaselineFrictionEffectivePressureEnum,
	BaselineSmbMassBalanceEnum,
	BedEnum,
	BedGRDEnum,
	BedEastEnum,
	BedEastGRDEnum,
	BedNorthEnum,
	BedNorthGRDEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BottomPressureEnum,
	BottomPressureOldEnum,
	CalvingCalvingrateEnum,
	CalvingHabFractionEnum,
	CalvingAblationrateEnum,
	CalvingMeltingrateEnum,
	CalvingStressThresholdFloatingiceEnum,
	CalvingStressThresholdGroundediceEnum,
	CalvinglevermannCoeffEnum,
	CalvingratexEnum,
	CalvingrateyEnum,
	CalvingFluxLevelsetEnum,
	CalvingMeltingFluxLevelsetEnum,
	ConvergedEnum,
	CrevasseDepthEnum,
	DamageDEnum,
	DamageDOldEnum,
	DamageDbarEnum,
	DamageDbarOldEnum,
	DamageFEnum,
	DebrisThicknessEnum,
	DegreeOfChannelizationEnum,
	DepthBelowSurfaceEnum,
	DeltaIceThicknessEnum,
	DeltaTwsEnum,
	DeltaBottomPressureEnum,
	DeltaDslEnum,
	DslOldEnum,
	DslEnum,
	DeltaStrEnum,
	StrOldEnum,
	StrEnum,
	DeviatoricStresseffectiveEnum,
	DeviatoricStressxxEnum,
	DeviatoricStressxyEnum,
	DeviatoricStressxzEnum,
	DeviatoricStressyyEnum,
	DeviatoricStressyzEnum,
	DeviatoricStresszzEnum,
	DeviatoricStress1Enum,
	DeviatoricStress2Enum,
	DistanceToCalvingfrontEnum,
	DistanceToGroundinglineEnum,
	Domain2DhorizontalEnum,
	Domain2DverticalEnum,
	Domain3DEnum,
	DragCoefficientAbsGradientEnum,
	DrivingStressXEnum,
	DrivingStressYEnum,
	DummyEnum,
   EffectivePressureEnum,
	EffectivePressureSubstepEnum,
	EffectivePressureTransientEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	EplHeadEnum,
   EplHeadOldEnum,
	EplHeadSlopeXEnum,
	EplHeadSlopeYEnum,
	EplHeadSubstepEnum,
   EplHeadTransientEnum,
	EsaEmotionEnum,
	EsaNmotionEnum,
	EsaRotationrateEnum,
	EsaStrainratexxEnum,
	EsaStrainratexyEnum,
	EsaStrainrateyyEnum,
	EsaUmotionEnum,
	EsaXmotionEnum,
	EsaYmotionEnum,
	EtaDiffEnum,
	FlowequationBorderFSEnum,
	FrictionAsEnum,
	FrictionCEnum,
	FrictionCmaxEnum,
	FrictionCoefficientEnum,
	FrictionCoefficientcoulombEnum,
	FrictionEffectivePressureEnum,
	FrictionMEnum,
	FrictionPEnum,
	FrictionPressureAdjustedTemperatureEnum,
	FrictionQEnum,
	FrictionSedimentCompressibilityCoefficientEnum,
	FrictionTillFrictionAngleEnum,
	FrictionWaterLayerEnum,
	FrictionWaterPressureEnum,
	FrictionWaterPressureNoiseEnum,
	FrictionfEnum,
	FrontalForcingsBasinIdEnum,
	FrontalForcingsSubglacialDischargearmaEnum,
	FrontalForcingsSubglacialDischargeEnum,
	GeometryHydrostaticRatioEnum,
	NGiaEnum,
	NGiaRateEnum,
	UGiaEnum,
	UGiaRateEnum,
	GradientEnum,
	GroundinglineHeightEnum,
	HydraulicPotentialEnum,
	HydraulicPotentialOldEnum,
	HydrologyBasalFluxEnum,
	HydrologyBasinsIdEnum,
	HydrologyBumpHeightEnum,
	HydrologyBumpSpacingEnum,
	HydrologyChannelConductivityEnum,
	HydrologydcBasalMoulinInputEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplThicknessOldEnum,
	HydrologydcEplThicknessSubstepEnum,
	HydrologydcEplThicknessTransientEnum,
	HydrologydcMaskEplactiveEltEnum,
	HydrologydcMaskEplactiveNodeEnum,
	HydrologydcMaskThawedEltEnum,
	HydrologydcMaskThawedNodeEnum,
	HydrologydcSedimentTransmitivityEnum,
   HydrologyDrainageRateEnum,
   HydrologyEnglacialInputEnum,
	HydrologyGapHeightEnum,
	HydrologyGapHeightXEnum,
	HydrologyGapHeightXXEnum,
	HydrologyGapHeightYEnum,
	HydrologyGapHeightYYEnum,
	HydrologyHeadEnum,
	HydrologyHeadOldEnum,
	HydrologyMoulinInputEnum,
	HydrologyNeumannfluxEnum,
	HydrologyReynoldsEnum,
	HydrologySheetConductivityEnum,
	HydrologySheetThicknessEnum,
	HydrologySheetThicknessOldEnum,
	HydrologyTwsEnum,
	HydrologyTwsSpcEnum,
	HydrologyTwsAnalysisEnum,
	HydrologyWatercolumnMaxEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	HydrologyMaskNodeActivationEnum,
	DebrisMaskNodeActivationEnum,
	IceEnum,
	IceMaskNodeActivationEnum,
	InputEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionSurfaceObsEnum,
	InversionThicknessObsEnum,
	InversionVelObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	LevelsetfunctionSlopeXEnum,
	LevelsetfunctionSlopeYEnum,
	LevelsetObservationEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	MaskOceanLevelsetEnum,
	MaskIceLevelsetEnum,
	MaskIceRefLevelsetEnum,
	MasstransportSpcthicknessEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyEEnum,
	MaterialsRheologyEbarEnum,
	MaterialsRheologyEcEnum,
	MaterialsRheologyEcbarEnum,
	MaterialsRheologyEsEnum,
	MaterialsRheologyEsbarEnum,
	MaterialsRheologyNEnum,
	MeshScaleFactorEnum,
	MeshVertexonbaseEnum,
	MeshVertexonboundaryEnum,
	MeshVertexonsurfaceEnum,
	MisfitEnum,
	MovingFrontalVxEnum,
	MovingFrontalVyEnum,
	NeumannfluxEnum,
	NewDamageEnum,
	NodeEnum,
	OmegaAbsGradientEnum,
	OceantransportSpcbottompressureEnum,
	OceantransportSpcstrEnum,
	OceantransportSpcdslEnum,
	P0Enum,
	P1Enum,
	PartitioningEnum,
	PressureEnum,
	RadarEnum,
	RadarAttenuationMacGregorEnum,
	RadarAttenuationWolffEnum,
	RadarIcePeriodEnum,
	RadarPowerMacGregorEnum,
	RadarPowerWolffEnum,
	RheologyBAbsGradientEnum,
	RheologyBInitialguessEnum,
	RheologyBInitialguessMisfitEnum,
	RheologyBbarAbsGradientEnum,
	SampleEnum,
	SampleOldEnum,
	SampleNoiseEnum,
	SamplingBetaEnum,
	SamplingKappaEnum,
	SamplingPhiEnum,
	SamplingTauEnum,
	SealevelEnum,
	SealevelGRDEnum,
	SatGraviGRDEnum,
	SealevelBarystaticMaskEnum,
	SealevelBarystaticIceMaskEnum,
	SealevelBarystaticIceWeightsEnum,
	SealevelBarystaticIceAreaEnum,
	SealevelBarystaticIceLatbarEnum,
	SealevelBarystaticIceLongbarEnum,
	SealevelBarystaticIceLoadEnum,
	SealevelBarystaticHydroMaskEnum,
	SealevelBarystaticHydroWeightsEnum,
	SealevelBarystaticHydroAreaEnum,
	SealevelBarystaticHydroLatbarEnum,
	SealevelBarystaticHydroLongbarEnum,
	SealevelBarystaticHydroLoadEnum,
	SealevelBarystaticBpMaskEnum,
	SealevelBarystaticBpWeightsEnum,
	SealevelBarystaticBpAreaEnum,
	SealevelBarystaticBpLoadEnum,
	SealevelBarystaticOceanMaskEnum,
	SealevelBarystaticOceanWeightsEnum,
	SealevelBarystaticOceanAreaEnum,
	SealevelBarystaticOceanLatbarEnum,
	SealevelBarystaticOceanLongbarEnum,
	SealevelBarystaticOceanLoadEnum,
	SealevelNEsaEnum,
	SealevelNEsaRateEnum,
	SealevelRSLEnum,
	BslcEnum,
	BslcIceEnum,
	BslcHydroEnum,
	BslcOceanEnum,
	BslcRateEnum,
	GmtslcEnum,
	SealevelRSLBarystaticEnum,
	SealevelRSLRateEnum,
	SealevelUGrdEnum,
	SealevelNGrdEnum,
	SealevelUEastEsaEnum,
	SealevelUNorthEsaEnum,
	SealevelchangeIndicesEnum,
	SealevelchangeConvolutionVerticesEnum,
	SealevelchangeAlphaIndexEnum,
	SealevelchangeAzimuthIndexEnum,
	SealevelchangeGrotEnum,
	SealevelchangeGSatGravirotEnum,
	SealevelchangeGUrotEnum,
	SealevelchangeGNrotEnum,
	SealevelchangeGErotEnum,
	SealevelchangeAlphaIndexOceanEnum,
	SealevelchangeAlphaIndexIceEnum,
	SealevelchangeAlphaIndexHydroEnum,
	SealevelchangeAzimuthIndexOceanEnum,
	SealevelchangeAzimuthIndexIceEnum,
	SealevelchangeAzimuthIndexHydroEnum,
	SealevelchangeViscousRSLEnum,
	SealevelchangeViscousSGEnum,
	SealevelchangeViscousUEnum,
	SealevelchangeViscousNEnum,
	SealevelchangeViscousEEnum,
	CouplingTransferCountEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadSubstepEnum,
	SedimentHeadTransientEnum,
	SedimentHeadResidualEnum,
	SedimentHeadStackedEnum,
	SigmaNNEnum,
	SigmaVMEnum,
	SmbAccumulatedECEnum,
	SmbAccumulatedMassBalanceEnum,
	SmbAccumulatedMeltEnum,
	SmbAccumulatedPrecipitationEnum,
	SmbAccumulatedRainEnum,
	SmbAccumulatedRefreezeEnum,
	SmbAccumulatedRunoffEnum,
	SmbAlbedoEnum,
	SmbAlbedoSnowEnum,
	SmbAEnum,
	SmbAdiffEnum,
	SmbAValueEnum,
	SmbAccumulationEnum,
	SmbAdiffiniEnum,
	SmbAiniEnum,
   SmbARMANoiseEnum,
	SmbBasinsIdEnum,
	SmbBMaxEnum,
	SmbBMinEnum,
	SmbBNegEnum,
	SmbBPosEnum,
	SmbCEnum,
	SmbCcsnowValueEnum,
	SmbCciceValueEnum,
	SmbCotValueEnum,
	SmbDEnum,
	SmbDailyairdensityEnum,
	SmbDailyairhumidityEnum,
	SmbDailydlradiationEnum,
	SmbDailydsradiationEnum,
	SmbDailypressureEnum,
	SmbDailyrainfallEnum,
	SmbDailysnowfallEnum,
	SmbDailytemperatureEnum,
	SmbDailywindspeedEnum,
	SmbDiniEnum,
	SmbDlwrfEnum,
	SmbDulwrfValueEnum,
	SmbDswrfEnum,
	SmbDswdiffrfEnum,
	SmbDzAddEnum,
	SmbDzEnum,
	SmbDzMinEnum,
	SmbDzTopEnum,
	SmbDziniEnum,
	SmbEAirEnum,
	SmbECEnum,
	SmbECDtEnum,
	SmbECiniEnum,
	SmbElaEnum,
	SmbEvaporationEnum,
	SmbFACEnum,
	SmbGdnEnum,
	SmbGdniniEnum,
	SmbGspEnum,
	SmbGspiniEnum,
	SmbHIceEnum,
	SmbHSnowEnum,
	SmbHrefEnum,
	SmbIsInitializedEnum,
	SmbMAddEnum,
	SmbMassBalanceEnum,
   SmbMassBalanceSubstepEnum,
   SmbMassBalanceTransientEnum,
	SmbMaskEnum,
	SmbMeanLHFEnum,
	SmbMeanSHFEnum,
	SmbMeanULWEnum,
	SmbMeltEnum,
	SmbMInitnum,
	SmbMonthlytemperaturesEnum,
	SmbMSurfEnum,
	SmbNetLWEnum,
	SmbNetSWEnum,
	SmbPAirEnum,
	SmbPEnum,
	SmbPddfacIceEnum,
	SmbPddfacSnowEnum,
	SmbPrecipitationEnum,
	SmbPrecipitationsAnomalyEnum,
	SmbPrecipitationsLgmEnum,
	SmbPrecipitationsPresentdayEnum,
	SmbPrecipitationsReconstructedEnum,
	SmbRainEnum,
	SmbReEnum,
	SmbRefreezeEnum,
	SmbReiniEnum,
	SmbRunoffEnum,
   SmbRunoffSubstepEnum,
   SmbRunoffTransientEnum,
	SmbS0gcmEnum,
	SmbS0pEnum,
	SmbS0tEnum,
	SmbSizeiniEnum,
	SmbSmbCorrEnum,
	SmbSmbrefEnum,
	SmbSzaValueEnum,
	SmbTEnum,
	SmbTaEnum,
	SmbTampEnum,
	SmbTeValueEnum,
	SmbTemperaturesAnomalyEnum,
	SmbTemperaturesLgmEnum,
	SmbTemperaturesPresentdayEnum,
	SmbTemperaturesReconstructedEnum,
	SmbTiniEnum,
	SmbTmeanEnum,
	SmbTzEnum,
	SmbValuesAutoregressionEnum,
	SmbValuesMovingaverageEnum,
	SmbVEnum,
	SmbVmeanEnum,
	SmbVzEnum,
	SmbWEnum,
	SmbWAddEnum,
	SmbWiniEnum,
	SmbZMaxEnum,
	SmbZMinEnum,
	SmbZTopEnum,
	SmbZYEnum,
	SolidearthExternalDisplacementEastRateEnum,
	SolidearthExternalDisplacementNorthRateEnum,
	SolidearthExternalDisplacementUpRateEnum,
	SolidearthExternalGeoidRateEnum,
	StochasticForcingDefaultIdEnum,
	StrainRateeffectiveEnum,
	StrainRateparallelEnum,
	StrainRateperpendicularEnum,
	StrainRatexxEnum,
	StrainRatexyEnum,
	StrainRatexzEnum,
	StrainRateyyEnum,
	StrainRateyzEnum,
	StrainRatezzEnum,
	StressMaxPrincipalEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	SubglacialdischargeARMANoiseEnum,
	SubglacialdischargeValuesAutoregressionEnum,
	SubglacialdischargeValuesMovingaverageEnum,
	SurfaceAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	AreaEnum,
	SealevelAreaEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceCrevasseEnum,
	SurfaceEnum,
	SurfaceOldEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceObservationEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePDDEnum,
	TemperaturePicardEnum,
	TemperatureSEMICEnum,
   ThermalforcingARMANoiseEnum,
	ThermalForcingEnum,
	ThermalforcingValuesAutoregressionEnum,
	ThermalforcingValuesMovingaverageEnum,
	ThermalSpctemperatureEnum,
	ThicknessAbsGradientEnum,
	ThicknessAbsMisfitEnum,
	ThicknessAcrossGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessEnum,
	ThicknessOldEnum,
	ThicknessPositiveEnum,
	ThicknessResidualEnum,
	TransientAccumulatedDeltaIceThicknessEnum,
	VelEnum,
	VxAverageEnum,
	VxBaseEnum,
	VxDebrisEnum,
	VxEnum,
	VxMeshEnum,
	VxObsEnum,
	VxShearEnum,
	VxSurfaceEnum,
	VyAverageEnum,
	VyBaseEnum,
	VyDebrisEnum,
	VyEnum,
	VyMeshEnum,
	VyObsEnum,
	VyShearEnum,
	VySurfaceEnum,
	VzEnum,
	VzFSEnum,
	VzHOEnum,
	VzMeshEnum,
	VzSSAEnum,
	WaterColumnOldEnum,
	WatercolumnEnum,
	WaterfractionDrainageEnum,
	WaterfractionDrainageIntegratedEnum,
	WaterfractionEnum,
	WaterheightEnum,
	WaterPressureArmaPerturbationEnum,
   WaterPressureValuesAutoregressionEnum,
   WaterPressureValuesMovingaverageEnum,
	WeightsLevelsetObservationEnum,
	WeightsSurfaceObservationEnum,
	OldAccumulatedDeltaBottomPressureEnum,
	OldAccumulatedDeltaIceThicknessEnum,
	OldAccumulatedDeltaTwsEnum,
	Outputdefinition1Enum,
	Outputdefinition10Enum,
	Outputdefinition11Enum,
	Outputdefinition12Enum,
	Outputdefinition13Enum,
	Outputdefinition14Enum,
	Outputdefinition15Enum,
	Outputdefinition16Enum,
	Outputdefinition17Enum,
	Outputdefinition18Enum,
	Outputdefinition19Enum,
	Outputdefinition20Enum,
	Outputdefinition21Enum,
	Outputdefinition22Enum,
	Outputdefinition23Enum,
	Outputdefinition24Enum,
	Outputdefinition25Enum,
	Outputdefinition26Enum,
	Outputdefinition27Enum,
	Outputdefinition28Enum,
	Outputdefinition29Enum,
	Outputdefinition2Enum,
	Outputdefinition30Enum,
	Outputdefinition31Enum,
	Outputdefinition32Enum,
	Outputdefinition33Enum,
	Outputdefinition34Enum,
	Outputdefinition35Enum,
	Outputdefinition36Enum,
	Outputdefinition37Enum,
	Outputdefinition38Enum,
	Outputdefinition39Enum,
	Outputdefinition3Enum,
	Outputdefinition40Enum,
	Outputdefinition41Enum,
	Outputdefinition42Enum,
	Outputdefinition43Enum,
	Outputdefinition44Enum,
	Outputdefinition45Enum,
	Outputdefinition46Enum,
	Outputdefinition47Enum,
	Outputdefinition48Enum,
	Outputdefinition49Enum,
	Outputdefinition4Enum,
	Outputdefinition50Enum,
	Outputdefinition51Enum,
	Outputdefinition52Enum,
	Outputdefinition53Enum,
	Outputdefinition54Enum,
	Outputdefinition55Enum,
	Outputdefinition56Enum,
	Outputdefinition57Enum,
	Outputdefinition58Enum,
	Outputdefinition59Enum,
	Outputdefinition5Enum,
	Outputdefinition60Enum,
	Outputdefinition61Enum,
	Outputdefinition62Enum,
	Outputdefinition63Enum,
	Outputdefinition64Enum,
	Outputdefinition65Enum,
	Outputdefinition66Enum,
	Outputdefinition67Enum,
	Outputdefinition68Enum,
	Outputdefinition69Enum,
	Outputdefinition6Enum,
	Outputdefinition70Enum,
	Outputdefinition71Enum,
	Outputdefinition72Enum,
	Outputdefinition73Enum,
	Outputdefinition74Enum,
	Outputdefinition75Enum,
	Outputdefinition76Enum,
	Outputdefinition77Enum,
	Outputdefinition78Enum,
	Outputdefinition79Enum,
	Outputdefinition7Enum,
	Outputdefinition80Enum,
	Outputdefinition81Enum,
	Outputdefinition82Enum,
	Outputdefinition83Enum,
	Outputdefinition84Enum,
	Outputdefinition85Enum,
	Outputdefinition86Enum,
	Outputdefinition87Enum,
	Outputdefinition88Enum,
	Outputdefinition89Enum,
	Outputdefinition8Enum,
	Outputdefinition90Enum,
	Outputdefinition91Enum,
	Outputdefinition92Enum,
	Outputdefinition93Enum,
	Outputdefinition94Enum,
	Outputdefinition95Enum,
	Outputdefinition96Enum,
	Outputdefinition97Enum,
	Outputdefinition98Enum,
	Outputdefinition99Enum,
	Outputdefinition9Enum,
	Outputdefinition100Enum,
	/*}}}*/
	InputsENDEnum,
	/*Other{{{*/
	AbsoluteEnum,
	AdaptiveTimesteppingEnum,
	AdjointBalancethickness2AnalysisEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AgeAnalysisEnum,
	AggressiveMigrationEnum,
	AmrBamgEnum,
	AmrNeopzEnum,
	AndroidFrictionCoefficientEnum,
	ArrheniusEnum,
	AutodiffJacobianEnum,
	Balancethickness2AnalysisEnum,
	Balancethickness2SolutionEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessApparentMassbalanceEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancethicknessSolutionEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	BasalforcingsIsmip6Enum,
	BasalforcingsPicoEnum,
	BeckmannGoosseFloatingMeltRateEnum,
	BedSlopeSolutionEnum,
	BoolExternalResultEnum,
	BoolInputEnum,
	IntInputEnum,
	DoubleInputEnum,
	BoolParamEnum,
	BoundaryEnum,
	BuddJackaEnum,
	CalvingDev2Enum,
	CalvingHabEnum,
	CalvingLevermannEnum,
	CalvingTestEnum,
	CalvingParameterizationEnum,
	CalvingVonmisesEnum,
	CalvingPollardEnum,
	CfdragcoeffabsgradEnum,
	CfsurfacelogvelEnum,
	CfsurfacesquareEnum,
	CflevelsetmisfitEnum,
	ChannelEnum,
	ChannelAreaEnum,
	ChannelAreaOldEnum,
	ChannelDischargeEnum,
	ClosedEnum,
	ColinearEnum,
	ConstraintsEnum,
	ContactEnum,
	ContourEnum,
	ContoursEnum,
	ControlInputEnum,
	ControlInputGradEnum,
	ControlInputMaxsEnum,
	ControlInputMinsEnum,
	ControlInputValuesEnum,
	CrouzeixRaviartEnum,
	CuffeyEnum,
	CuffeyTemperateEnum,
	DamageEvolutionAnalysisEnum,
	DamageEvolutionSolutionEnum,
	DataSetEnum,
	DataSetParamEnum,
	DatasetInputEnum,
	DebrisAnalysisEnum,
	DebrisSolutionEnum,
	DefaultAnalysisEnum,
	DefaultCalvingEnum,
	DenseEnum,
	DependentObjectEnum,
	DepthAverageAnalysisEnum,
	DeviatoricStressErrorEstimatorEnum,
	DivergenceEnum,
	Domain3DsurfaceEnum,
	DoubleArrayInputEnum,
	ArrayInputEnum,
	IntArrayInputEnum,
	DoubleExternalResultEnum,
	DoubleMatArrayParamEnum,
	DoubleMatExternalResultEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementHookEnum,
	ElementSIdEnum,
	EnthalpyAnalysisEnum,
	EsaAnalysisEnum,
	EsaSolutionEnum,
	EsaTransitionsEnum,
	ExternalResultEnum,
	ExtrapolationAnalysisEnum,
	ExtrudeFromBaseAnalysisEnum,
	ExtrudeFromTopAnalysisEnum,
	FSApproximationEnum,
	FSSolverEnum,
	FSpressureEnum,
	FSvelocityEnum,
	FemModelEnum,
	FileParamEnum,
	FixedTimesteppingEnum,
	FloatingAreaEnum,
	FloatingAreaScaledEnum,
	FloatingMeltRateEnum,
	FreeEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	FrontalForcingsDefaultEnum,
	FrontalForcingsRignotEnum,
	FrontalForcingsRignotarmaEnum,
	FsetEnum,
	FullMeltOnPartiallyFloatingEnum,
	GLheightadvectionAnalysisEnum,
	GaussPentaEnum,
	GaussSegEnum,
	GaussTetraEnum,
	GaussTriaEnum,
	GenericOptionEnum,
	GenericParamEnum,
	GenericExternalResultEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	Gradient4Enum,
	GroundedAreaEnum,
	GroundedAreaScaledEnum,
	GroundingOnlyEnum,
	GroundinglineMassFluxEnum,
	GsetEnum,
	GslEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	HookEnum,
	HydrologyArmapwAnalysisEnum,
   HydrologyarmapwEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyGlaDSAnalysisEnum,
	HydrologyGlaDSEnum,
	HydrologyPismAnalysisEnum,
	HydrologyShaktiAnalysisEnum,
	HydrologyShreveAnalysisEnum,
	HydrologySolutionEnum,
	HydrologySubstepsEnum,
	HydrologySubTimeEnum,
	HydrologydcEnum,
	HydrologypismEnum,
	HydrologyshaktiEnum,
	HydrologyshreveEnum,
	IceMassEnum,
	IceMassScaledEnum,
	IceVolumeAboveFloatationEnum,
	IceVolumeAboveFloatationScaledEnum,
	IceVolumeEnum,
	IceVolumeScaledEnum,
	IcefrontMassFluxEnum,
	IcefrontMassFluxLevelsetEnum,
	IncrementalEnum,
	IndexedEnum,
	IntExternalResultEnum,
	ElementInputEnum,
	IntMatExternalResultEnum,
	IntMatParamEnum,
	IntParamEnum,
	IntVecParamEnum,
	InputsEnum,
	InternalEnum,
	IntersectEnum,
	InversionVzObsEnum,
	JEnum,
	L1L2ApproximationEnum,
	MOLHOApproximationEnum,
	L2ProjectionBaseAnalysisEnum,
	L2ProjectionEPLAnalysisEnum,
	LACrouzeixRaviartEnum,
	LATaylorHoodEnum,
	LambdaSEnum,
	LevelsetAnalysisEnum,
	LevelsetfunctionPicardEnum,
	LinearFloatingMeltRateEnum,
	LinearFloatingMeltRatearmaEnum,
	LliboutryDuvalEnum,
	LoadsEnum,
	LoveAnalysisEnum,
	LoveHfEnum,
	LoveHtEnum,
	LoveKernelsImagEnum,
	LoveKernelsRealEnum,
	LoveKfEnum,
	LoveKtEnum,
	LoveLfEnum,
	LoveLtEnum,
	LoveTidalHtEnum,
	LoveTidalKtEnum,
	LoveTidalLtEnum,
	LovePMTF1tEnum,
	LovePMTF2tEnum,
	LoveYiEnum,
	LoveRhsEnum,
	LoveSolutionEnum,
	MINIEnum,
	MINIcondensedEnum,
	MantlePlumeGeothermalFluxEnum,
	MassFluxEnum,
	MassconEnum,
	MassconaxpbyEnum,
	MassfluxatgateEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	MatdamageiceEnum,
	MatenhancediceEnum,
	MaterialsEnum,
	MatestarEnum,
	MaticeEnum,
	MatlithoEnum,
	MathydroEnum,
	MatrixParamEnum,
	MaxAbsVxEnum,
	MaxAbsVyEnum,
	MaxAbsVzEnum,
	MaxDivergenceEnum,
	MaxVelEnum,
	MaxVxEnum,
	MaxVyEnum,
	MaxVzEnum,
	MelangeEnum,
	MeltingAnalysisEnum,
	MeshElementsEnum,
	MeshXEnum,
	MeshYEnum,
	MinVelEnum,
	MinVxEnum,
	MinVyEnum,
	MinVzEnum,
	MismipFloatingMeltRateEnum,
	MoulinEnum,
	MpiDenseEnum,
	MpiEnum,
	MpiSparseEnum,
	MumpsEnum,
	NoFrictionOnPartiallyFloatingEnum,
	NoMeltOnPartiallyFloatingEnum,
	NodalEnum,
	NodalvalueEnum,
	NodeSIdEnum,
	NoneApproximationEnum,
	NoneEnum,
	NumberedcostfunctionEnum,
	NyeCO2Enum,
	NyeH2OEnum,
	NumericalfluxEnum,
	OceantransportAnalysisEnum,
	OceantransportSolutionEnum,
	OldGradientEnum,
	OneLayerP4zEnum,
	OpenEnum,
	OptionEnum,
	ParamEnum,
	ParametersEnum,
	P0ArrayEnum,
	P0DGEnum,
	P1DGEnum,
	P1P1Enum,
	P1P1GLSEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P1xP2Enum,
	P1xP3Enum,
	P1xP4Enum,
	P2Enum,
	P2bubbleEnum,
	P2bubblecondensedEnum,
	P2xP1Enum,
	P2xP4Enum,
	PatersonEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaInputEnum,
	ProfilerEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingCurrentMemEnum,
	ProfilingSolutionTimeEnum,
	RegionaloutputEnum,
	RegularEnum,
	RecoveryAnalysisEnum,
	RiftfrontEnum,
	SamplingAnalysisEnum,
	SamplingSolutionEnum,
	SIAApproximationEnum,
	SMBarmaEnum,
	SMBcomponentsEnum,
	SMBdebrisMLEnum,
	SMBd18opddEnum,
	SMBforcingEnum,
	SMBgcmEnum,
	SMBgembEnum,
	SMBgradientsEnum,
	SMBgradientscomponentsEnum,
	SMBgradientselaEnum,
	SMBhenningEnum,
	SMBmeltcomponentsEnum,
	SMBpddEnum,
	SMBpddSicopolisEnum,
	SMBsemicEnum,
	SSAApproximationEnum,
	SSAFSApproximationEnum,
	SSAHOApproximationEnum,
	ScaledEnum,
	SealevelAbsoluteEnum,
	SealevelEmotionEnum,
	SealevelchangePolarMotionXEnum,
	SealevelchangePolarMotionYEnum,
	SealevelchangePolarMotionZEnum,
	SealevelchangePolarMotionEnum,
	SealevelNmotionEnum,
	SealevelUmotionEnum,
	SealevelchangeAnalysisEnum,
	SegEnum,
	SegInputEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SeparateEnum,
	SeqEnum,
	SmbAnalysisEnum,
	SmbSolutionEnum,
	SmoothAnalysisEnum,
	SoftMigrationEnum,
	SpatialLinearFloatingMeltRateEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	SsetEnum,
	StatisticsSolutionEnum,
	SteadystateSolutionEnum,
	StressIntensityFactorEnum,
	StressbalanceAnalysisEnum,
	StressbalanceConvergenceNumStepsEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	StringArrayParamEnum,
	StringExternalResultEnum,
	StringParamEnum,
	SubelementFriction1Enum,
	SubelementFriction2Enum,
	SubelementMelt1Enum,
	SubelementMelt2Enum,
	SubelementMigrationEnum,
	SurfaceSlopeSolutionEnum,
	TaylorHoodEnum,
	TetraEnum,
	TetraInputEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	ThicknessErrorEstimatorEnum,
	TotalCalvingFluxLevelsetEnum,
	TotalCalvingMeltingFluxLevelsetEnum,
	TotalFloatingBmbEnum,
	TotalFloatingBmbScaledEnum,
	TotalGroundedBmbEnum,
	TotalGroundedBmbScaledEnum,
	TotalSmbEnum,
	TotalSmbScaledEnum,
	TransientArrayParamEnum,
	TransientInputEnum,
	TransientParamEnum,
	TransientSolutionEnum,
	TriaEnum,
	TriaInputEnum,
	UzawaPressureAnalysisEnum,
	VectorParamEnum,
	VertexEnum,
	VertexLIdEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	VerticesEnum,
	ViscousHeatingEnum,
	WaterEnum,
	XTaylorHoodEnum,
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Unused?{{{*/
	BalancethicknessD0Enum,
	BalancethicknessDiffusionCoefficientEnum,
	BilinearInterpEnum,
	CalvingdevCoeffEnum,
	DeviatoricStressEnum,
	EtaAbsGradientEnum,
	MeshZEnum,
	NearestInterpEnum,
	OutputdefinitionListEnum,
	SealevelObsEnum,
	SealevelWeightsEnum,
	StrainRateEnum,
	StressTensorEnum,
	StressbalanceViscosityOvershootEnum,
	SubelementMigration4Enum,
	TimesteppingTimeAdaptEnum,
	TriangleInterpEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
