subroutine run_semic_transient(sf_in, rf_in, swd_in, lwd_in, wind_in, &
      sp_in, rhoa_in, qq_in, tt_in, tsurf_in, tstic, &
      hcrit, rcrit, &
      mask, hice, hsnow, &
      albedo, albedo_snow, alb_scheme, alb_smax, alb_smin, albi, albl, &
      Tamp, &
      tsurf_out, smb_out, saccu_out, smelt_out, alb_out, alb_snow_out,hsnow_out,hice_out)

   use utils
   use surface_physics

   implicit none

   ! declare surface physics class
   type(surface_physics_class) :: surface
   ! declare forcing class
   type(forc_class) :: forc
   ! declare validation class
   !type(vali_class) :: vali	! validation not needed here

   integer, parameter:: dp=kind(0.d0)  !< define precision (machine specific)
   integer :: i, k, nx, nloop, ntime, year
   integer :: day=1 !< not used value.

   ! forcing data    
   double precision, intent(in) :: sf_in  ! snow fall rate [m/s]
   double precision, intent(in) :: rf_in  ! rain fall rate [m/s]
   double precision, intent(in) :: swd_in ! downwelling shortwave radiation [W/m2]
   double precision, intent(in) :: lwd_in ! downwelling longwave radiation [W/m2]
   double precision, intent(in) :: wind_in! surface wind speed [m/s]
   double precision, intent(in) :: sp_in  ! surface pressure [Pa]
   double precision, intent(in) :: rhoa_in! air density [kg/m3]
   double precision, intent(in) :: qq_in  ! air specific humidity [kg/kg]
   double precision, intent(in) :: tt_in  ! air temperature [K]

   ! input data
   double precision, intent(in) :: tstic  ! time step from ISSM [sec].
   double precision, intent(in) :: tsurf_in ! input temperature [K]

   ! output data
   double precision :: tsurf_out  ! Ice surface Temperature [K]
   double precision :: smb_out    ! surface mass balance=(Accu-Melt) [m/s]
   double precision :: saccu_out  ! accumulation [m/s]
   double precision :: smelt_out  ! ablation [m/s]
   double precision :: alb_out    ! grid-averaged albedo [no unit] 
   double precision :: alb_snow_out  
   double precision :: qmr_out    
   double precision :: hice_out    
   double precision :: hsnow_out 

   double precision :: total_time, start, finish

   ! set parameters
   character (len=256) :: name         ! not used(?)
   character (len=256) :: boundary(30) ! not used(?)
   !character (len=256), intent(in) :: alb_scheme  !< name of albedo scheme
   integer, intent(in)          :: alb_scheme
   integer :: n_ksub    
   double precision             :: ceff         !< surface heat heat capacity of snow/ice [J/W m2]
   double precision, intent(in) :: hsnow
   double precision, intent(in) :: hice
   double precision, intent(in) :: albi
   double precision, intent(in) :: albl
   double precision, intent(in) :: mask
   double precision, intent(in) :: albedo  
   double precision, intent(in) :: albedo_snow 
   double precision, intent(in) :: alb_smax
   double precision, intent(in) :: alb_smin
   double precision, intent(in) :: hcrit !< critical snow height for which grid cell is 50% snow covered [m]
   double precision, intent(in) :: rcrit !< critical snow height fro which refreezing fraction is 50% [m]
   double precision, intent(in) :: Tamp
   double precision    :: csh
   double precision    :: clh
   double precision    :: tmin
   double precision    :: tmax
   double precision    :: tsticsub
   ! parameters for isba albedo scheme.
   double precision    :: tau_a  !< critical liquide water concent for "isba" albedo scheme [kg/m2]
   double precision    :: tau_f
   double precision    :: w_crit
   double precision    :: mcrit
   double precision    :: afac !< param
   double precision    :: tmid !< param for "alex" albedo parameterization [K]

   nx = 1
   ntime = 365
   year = 0

   ! set vector length
   surface%par%nx = nx

   ! set input (forcing data)
   !forc%sf(:,:) = sf_in      ! snowfall flux [m/sec]
   !forc%rf(:,:) = rf_in      ! rainfall flux [m/sec]
   !forc%swd(:,:) = swd_in    ! short radiation
   !forc%lwd(:,:) = lwd_in    ! long radiation downward
   !forc%wind(:,:) = wind_ina ! wind speed.
   !forc%sp(:,:) = sp_in      ! surface pressure
   !forc%rhoa(:,:) = rhoa_in  ! air density [kg/m3]
   !forc%qq(:,:) = qq_in      ! air specific humidity [kg/kg]
   !forc%tt(:,:) = tt_in      ! 2m air temperature 

   ! FIXME should be user input
   !boundary = "" "" ""
   !surface%par%tstic = 86400.0_dp !< time step [s] in one day.
   surface%par%tstic = tstic      !< time step [s]
   surface%par%ceff= 2.0e6_dp     !< surface heat capacity of snow/ice [J/K/m2]
   surface%par%csh = 2.0e-3_dp
   surface%par%clh = 5.0e-4_dp    !< latent heat exchange coefficient [no unit]
   surface%par%alb_smax = alb_smax !0.79_dp !< max snow albedo
   surface%par%alb_smin = alb_smin !0.6_dp  !< min snow albedo
   surface%par%albi = albi !0.41_dp     !< albedo for ice
   surface%par%albl = albl !0.07_dp     !< albedo for land
   surface%par%tmin = -999_dp
   surface%par%tmax = 273.15_dp
   surface%par%hcrit = hcrit !0.028_dp   !< critical snow height for which grid cell is 50 % snow colvered [m]
   surface%par%rcrit = rcrit !0.85_dp    !< refreezing fraction is 50% [m]
   surface%par%amp   = Tamp !3.0_dp   !< amplitude of diurnal cycle [K]
   if (alb_scheme == 0) then
      surface%par%alb_scheme="None"
   else if (alb_scheme == 1) then
      surface%par%alb_scheme = "slater"
   else if (alb_scheme == 2) then
      surface%par%alb_scheme = "denby"
   else if (alb_scheme == 3) then
      surface%par%alb_scheme = "isba"
   end if 
   surface%par%tau_a = 0.008_dp
   surface%par%tau_f = 0.24_dp
   surface%par%w_crit = 15.0_dp
   surface%par%mcrit = 6.0e-8_dp
   surface%par%n_ksub = 3.0_dp
   
   ! initialize sub-daily time step tsticsub
   surface%par%tsticsub = surface%par%tstic / dble(surface%par%n_ksub)

   ! allocate necessary arrays for surface_physics module
   call surface_alloc(surface%now,surface%par%nx)

   ! initialise prognostic variables
   ! these values will be updated through "surface_energy_and_mass_balance" function.
   surface%now%mask(:)     = mask   ! 2.0_dp  !loi_mask(:nx)
   surface%now%hsnow(:)    = hsnow  ! 1.0_dp !< snow height...
   surface%now%hice(:)     = hice   ! 0.0_dp !< ice thickness...
   surface%now%tsurf(:)    = tsurf_in
   surface%now%alb(:)      = albedo ! 0.8_dp   !< initial albedo
   surface%now%alb_snow(:) = albedo_snow ! 0.8_dp
   !surface%now%acc(:)   = 0.0_dp
   !surface%now%smb(:)   = 0.0_dp
   !surface%now%melt(:)  = 0.0_dp
   surface%now%qmr_res(:) = 0.0_dp

   ! initialize with zeros
   surface%now%qmr(:) = 0.0_dp

   tsurf_out = 0.0_dp
   smb_out = 0.0_dp
   saccu_out = 0.0_dp
   smelt_out = 0.0_dp
   alb_out = 0.0_dp

   ! define boundary conditions (not used, here!)
   call surface_boundary_define(surface%bnd,surface%par%boundary)
   !call print_boundary_opt(surface%bnd)


   !surface%now%sf = forc%sf(1,day)
   !surface%now%rf = forc%rf(1,day)
   !surface%now%sp = forc%sp(1,day)
   !surface%now%lwd = forc%lwd(1,day)
   !surface%now%swd = forc%swd(1,day)
   !surface%now%wind = forc%wind(1,day)
   !surface%now%rhoa = forc%rhoa(1,day)
   !surface%now%t2m = forc%tt(1,day)
   !surface%now%qq = forc%qq(1,day)
   
   ! input with single value
   surface%now%sf   = sf_in
   surface%now%rf   = rf_in
   surface%now%sp   = sp_in
   surface%now%lwd  = lwd_in
   surface%now%swd  = swd_in
   surface%now%wind = wind_in
   surface%now%rhoa = rhoa_in
   surface%now%t2m  = tt_in
   surface%now%qq   = qq_in

   ! calculate prognostic and diagnsotic variables
   call cpu_time(start)
   call surface_energy_and_mass_balance(surface%now,surface%par,surface%bnd,day,-1)
   call cpu_time(finish)
   total_time = total_time + (finish - start)

   tsurf_out=surface%now%tsurf(1)
   ! melt - potential surface melt [m/s]
   ! smb
   smb_out   =surface%now%smb(1) !*1.0_dp/365.0_dp
   saccu_out =surface%now%acc(1) !*1.0_dp/365.0_dp
   smelt_out =surface%now%melt(1)!*1.0_dp/365.0_dp
   alb_out   =surface%now%alb(1)
   alb_snow_out  =surface%now%alb_snow(1)
   qmr_out    =surface%now%qmr(1)
   hsnow_out  =surface%now%hsnow(1)
   hice_out   =surface%now%hice(1)

   ! de-allocate surface_physics arrays
   call surface_dealloc(surface%now)

   !write(*,*) 'total time for surface_physics:', nloop, total_time

end subroutine run_semic_transient
