/*\file Bamg.c
 *\brief: bamg module.
 */

#include "./Bamg.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*inputs: */
	double* elements=NULL;
	int     dummy;
	double* x=NULL;
	double* y=NULL;
	double* metric=NULL;
	int     nods,nel;
	double  gradation;
	int     splitpbedge;
	int     nbv;

	/*output: */
	double* elementsout=NULL;
	double* xout=NULL;
	double* yout=NULL;
	int     nodsout,nelout;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*Input datasets: */
	FetchData(&elements,&nel,&dummy,ELEMENTS);
	FetchData(&x,&nods,X);
	FetchData(&y,&nods,Y);
	FetchData(&metric,&nods,METRIC);
	FetchData(&gradation,GRADATION);
	FetchData(&splitpbedge,SPLITPBEDGE);
	FetchData(&nbv,NBV);
	
	/*!Generate internal degree of freedom numbers: */
	Bamgx(&elementsout,&xout,&yout,&nelout,&nodsout,elements,x,y,nel,nods,metric,gradation,splitpbedge,nbv);

	/*write output datasets: */
	WriteData(ELEMENTSOUT,elementsout,nelout,3);
	WriteData(XOUT,xout,nodsout);
	WriteData(YOUT,yout,nodsout);

	/*Free ressources: */
	xfree((void**)&elements);
	xfree((void**)&x);
	xfree((void**)&y);
	xfree((void**)&metric);
	xfree((void**)&elementsout);
	xfree((void**)&xout);
	xfree((void**)&yout);

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,x,y]=%s(elements,x,y,metric,gradation,splitpbedge,nbv);\n",__FUNCT__);
	_printf_("\n");
}
