function [totalarea,groundediceelements]=groundedicearea(md)

	times=md.timestepping.start_time:md.timestepping.time_step:md.timestepping.final_time;
	nt=length(times); 

	totalarea=zeros(nt,1);
	areas=GetAreasSphericalTria(md.mesh.elements,md.mesh.lat,md.mesh.long,planetradius('earth'));

	rho_ice=md.materials.rho_ice;
	rho_water=md.materials.rho_water;
	oceanarea=3.619e+14;

	groundediceelements=zeros(md.mesh.numberofelements,nt);
	for t=1:nt-1, 
	
		time=times(t);

		tocean=md.mask.ocean_levelset(end,:);
		ind=findind(time,tocean);
		ocean=md.mask.ocean_levelset(1:end-1,ind);

		tice=md.mask.ice_levelset(end,:); 
		ind=findind(time,tice);
		ice=md.mask.ice_levelset(1:end-1,ind);
		
		masks.isiceonly=isiceonly(ice(md.mesh.elements));
		masks.isoceanin=isoceanin(ocean(md.mesh.elements));
		masks.isfullyfloating=isfullyfloating(ocean(md.mesh.elements));
		masks.notfullygrounded=notfullygrounded(ocean(md.mesh.elements));

		%Go through elements and sum up: 
		pos=find(masks.isiceonly & ~masks.isfullyfloating);
		totalarea(t)=sum(areas(pos));

		flags=zeros(md.mesh.numberofelements,1);
		flags(pos)=1;
		groundediceelements(:,t)=flags;
	end
end
function ind=findind(t,ts) % {{{

	nts=length(ts);
	if t<ts(2), 
		ind=1; 
	elseif t>=ts(end), 
		ind=nts;
	end;
	for i=2:nts-1, 
		if (t>=ts(i) & t<ts(i+1)),
			ind=i;
			break;
		end
	end
end   % }}}
function flags=isiceonly(ice) % {{{
	flags=max(ice,[],2)<0.0;
end % }}}
function flag=isoceanin(ocean)% {{{
	flag=min(ocean,[],2)<0;
end% }}}
function flags=isfullyfloating(ocean)% {{{
	flags=max(ocean,[],2)<=0;
end% }}}
function flags=notfullygrounded(ocean)% {{{
	flags=zeros(length(ocean),1);
	pos=find(min(ocean,[],2)<0); 
	flags(pos)=1; 
end% }}}
