/*!\file: debris_core.cpp
 * \brief: core of the debris solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"
#include "../classes/Inputs/TransientInput.h"

void debris_core(FemModel* femmodel){ /*{{{*/

	/*Start profiler*/
	femmodel->profiler->Start(DEBRISCORE);

	/*parameters: */
	int    numoutputs,domaintype;
	bool   save_results;
	int    solution_type,stabilization;
	char** requested_outputs = NULL;
	DebrisAnalysis * debris_analysis = NULL;

	/*activate configuration*/
	femmodel->SetCurrentConfiguration(DebrisAnalysisEnum);

	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);
	femmodel->parameters->FindParam(&numoutputs,DebrisNumRequestedOutputsEnum);
	if(numoutputs) femmodel->parameters->FindParam(&requested_outputs,&numoutputs,DebrisRequestedOutputsEnum);

	if(VerboseSolution()) _printf0_("   computing debris transport\n");

	// We need surface and bed slopes for removal model
	surfaceslope_core(femmodel);
	bedslope_core(femmodel);

	/*Transport Debris*/
	if(VerboseSolution()) _printf0_("   call computational core\n");
	//InputDuplicatex(femmodel,VxEnum,VxDebrisEnum);
	femmodel->inputs->DuplicateInput(VxEnum,VxDebrisEnum);
	//InputDuplicatex(femmodel,VyEnum,VyDebrisEnum);
	debris_analysis = new DebrisAnalysis();
	//debris_analysis->PreCore(femmodel);
	//femmodel->parameters->SetParam(VxDebrisEnum,InputToExtrudeEnum);
	//extrudefromtop_core(femmodel);	

	debris_analysis->Core(femmodel);
	delete debris_analysis;

	femmodel->parameters->SetParam(DebrisThicknessEnum,InputToExtrudeEnum);
	extrudefromtop_core(femmodel);	
	//femmodel->parameters->SetParam(VxDebrisEnum,InputToExtrudeEnum);
	//extrudefromtop_core(femmodel);

	if(save_results) femmodel->RequestedOutputsx(&femmodel->results,requested_outputs,numoutputs);

	if(solution_type==DebrisSolutionEnum)femmodel->RequestedDependentsx();

	/*Free ressources:*/
	if(numoutputs){for(int i=0;i<numoutputs;i++){xDelete<char>(requested_outputs[i]);} xDelete<char*>(requested_outputs);}

	/*profiler*/
	femmodel->profiler->Stop(DEBRISCORE);
} /*}}}*/
