%FRONTAL FORCINGS rignot arma class definition
%
%   Usage:
%      frontalforcingsrignotarma=frontalforcingsrignotarma();

classdef frontalforcingsrignotarma
	properties (SetAccess=public) 
		num_basins           = 0;
		const                = NaN;
		trend                = NaN;
		ar_order             = 0;
		ma_order             = 0;
		arma_initialtime     = 0;
		arma_timestep        = 0;
		arlag_coefs          = NaN;
		malag_coefs          = NaN;
		basin_id             = NaN;
		subglacial_discharge = NaN;
	end
	methods
		function self = frontalforcingsrignotarma(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				case 1
					inputstruct=varargin{1};
					list1 = properties('frontalforcingsrignotarma');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							self.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{
		    % nothing for now
		end % }}}
		function self = setdefaultparameters(self) % {{{

			self.basin_id             = NaN;
			self.num_basins           = 0;
			self.subglacial_discharge = NaN;
			self.ar_order             = 0.0; %autoregression model of order 0
			self.ma_order             = 0.0; %moving-average model of order 0

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			%Early return
			if (~strcmp(solution,'TransientSolution') | md.transient.ismovingfront==0), return; end

			md = checkfield(md,'fieldname','frontalforcings.num_basins','numel',1,'NaN',1,'Inf',1,'>',0);
         md = checkfield(md,'fieldname','frontalforcings.basin_id','Inf',1,'>=',0,'<=',md.frontalforcings.num_basins,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','frontalforcings.subglacial_discharge','>=',0,'NaN',1,'Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','frontalforcings.const','NaN',1,'Inf',1,'size',[1,md.frontalforcings.num_basins],'numel',md.frontalforcings.num_basins); 
         md = checkfield(md,'fieldname','frontalforcings.trend','NaN',1,'Inf',1,'size',[1,md.frontalforcings.num_basins],'numel',md.frontalforcings.num_basins); 
         md = checkfield(md,'fieldname','frontalforcings.ar_order','numel',1,'NaN',1,'Inf',1,'>=',0);
         md = checkfield(md,'fieldname','frontalforcings.ma_order','numel',1,'NaN',1,'Inf',1,'>=',0);
         md = checkfield(md,'fieldname','frontalforcings.arma_initialtime','numel',1,'NaN',1,'Inf',1);
         md = checkfield(md,'fieldname','frontalforcings.arma_timestep','numel',1,'NaN',1,'Inf',1,'>=',md.timestepping.time_step); %ARMA time step cannot be finer than ISSM timestep
			md = checkfield(md,'fieldname','frontalforcings.arlag_coefs','NaN',1,'Inf',1,'size',[md.frontalforcings.num_basins,md.frontalforcings.ar_order]);
			md = checkfield(md,'fieldname','frontalforcings.malag_coefs','NaN',1,'Inf',1,'size',[md.frontalforcings.num_basins,md.frontalforcings.ma_order]);

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   Frontalforcings parameters:'));
			fielddisplay(self,'num_basins','number of different basins [unitless]');
         fielddisplay(self,'basin_id','basin number assigned to each element [unitless]');
         fielddisplay(self,'subglacial_discharge','sum of subglacial discharge for each basin [m/d]');
         fielddisplay(self,'const','basin-specific constant term [∘C]');
         fielddisplay(self,'trend','basin-specific trend values [∘C yr^(-1)]');
         fielddisplay(self,'ar_order','order of the autoregressive model [unitless]');
         fielddisplay(self,'ma_order','order of the moving-average model [unitless]');
         fielddisplay(self,'arma_initialtime','initial time assumed in the ARMA model parameterization [yr]');
         fielddisplay(self,'arma_timestep','time resolution of the autoregressive model [yr]');
         fielddisplay(self,'arlag_coefs','basin-specific vectors of AR lag coefficients [unitless]');
         fielddisplay(self,'malag_coefs','basin-specific vectors of MA lag coefficients [unitless]');
		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			yts=md.constants.yts;
			WriteData(fid,prefix,'name','md.frontalforcings.parameterization','data',3,'format','Integer');
			WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','num_basins','format','Integer');
			WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','subglacial_discharge','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',yts);
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','ar_order','format','Integer');
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','ma_order','format','Integer');
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','arma_initialtime','format','Double','scale',yts);
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','arma_timestep','format','Double','scale',yts);
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','basin_id','data',self.basin_id-1,'name','md.frontalforcings.basin_id','format','IntMat','mattype',2); %0-indexed
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','const','format','DoubleMat','name','md.frontalforcings.const');
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','trend','format','DoubleMat','name','md.frontalforcings.trend','scale',1./yts,'yts',yts);
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','arlag_coefs','format','DoubleMat','name','md.frontalforcings.arlag_coefs','yts',yts);
         WriteData(fid,prefix,'object',self,'class','frontalforcings','fieldname','malag_coefs','format','DoubleMat','name','md.frontalforcings.malag_coefs','yts',yts);
		end % }}}
	end
end
