#include "./OceantransportAnalysis.h"
#include <math.h>
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../classes/Inputs/TransientInput.h"
#include "../classes/Inputs/TriaInput.h"
#include "../classes/gauss/Gauss.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
void OceantransportAnalysis::CreateConstraints(Constraints* constraints,IoModel* iomodel){/*{{{*/
	/*No constraints*/
}/*}}}*/
void OceantransportAnalysis::CreateLoads(Loads* loads, IoModel* iomodel){/*{{{*/
	/*No loads*/
}/*}}}*/
void OceantransportAnalysis::CreateNodes(Nodes* nodes,IoModel* iomodel,bool isamr){/*{{{*/
	::CreateNodes(nodes,iomodel,OceantransportAnalysisEnum,P1Enum);
}/*}}}*/
int  OceantransportAnalysis::DofsPerNode(int** doflist,int domaintype,int approximation){/*{{{*/
	return 3;
}/*}}}*/
void OceantransportAnalysis::UpdateElements(Elements* elements,Inputs* inputs,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	int  nature=0;
	bool isdakota=0;

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(inputs,i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	/*Plug inputs into element:*/
	iomodel->FetchDataToInput(inputs,elements,"md.dsl.sea_water_pressure_at_sea_floor", OceantransportSpcbottompressureEnum);
	iomodel->FetchDataToInput(inputs,elements,"md.dsl.sea_surface_height_above_geoid",  OceantransportSpcdslEnum);
	iomodel->FetchDataToInput(inputs,elements,"md.dsl.global_average_thermosteric_sea_level",OceantransportSpcstrEnum);

	/*Initialize sea level cumulated sea level loads :*/
	iomodel->ConstantToInput(inputs,elements,0.,AccumulatedDeltaBottomPressureEnum,P1Enum);
	iomodel->ConstantToInput(inputs,elements,0.,OldAccumulatedDeltaBottomPressureEnum,P1Enum);
	iomodel->FetchDataToInput(inputs,elements,"md.initialization.bottompressure",BottomPressureEnum);
	iomodel->FetchDataToInput(inputs,elements,"md.initialization.dsl",DslEnum);
	iomodel->FetchDataToInput(inputs,elements,"md.initialization.str",StrEnum);

}/*}}}*/
void OceantransportAnalysis::UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/

	int dslmodel=0;
	int     numoutputs;
	char**  requestedoutputs = NULL;

	/*Deal with dsl multi-model ensembles: {{{*/
	iomodel->FetchData(&dslmodel,"md.dsl.model");
	if(dslmodel==2){
		IssmDouble modelid; 
		int nummodels;

		/*create double param, not int param, because Dakota will be updating it as 
		 * a double potentially: */
		iomodel->FetchData(&modelid,"md.dsl.modelid");
		parameters->AddObject(new DoubleParam(DslModelidEnum,modelid));
		parameters->AddObject(iomodel->CopyConstantObject("md.dsl.nummodels",DslNummodelsEnum));
		iomodel->FetchData(&nummodels,"md.dsl.nummodels");

		/*quick checks: */
		if(nummodels<=0)_error_("dslmme object in  md.dsl field should contain at least 1 ensemble model!");
		if(modelid<=0 || modelid>nummodels)_error_("modelid field in dslmme object of md.dsl field should be between 1 and the number of ensemble runs!");
	} /*}}}*/
	/*Requested outputs {{{*/
	iomodel->FindConstant(&requestedoutputs,&numoutputs,"md.solidearth.requested_outputs");
	if(numoutputs)parameters->AddObject(new StringArrayParam(SealevelchangeRequestedOutputsEnum,requestedoutputs,numoutputs));
	iomodel->DeleteData(&requestedoutputs,numoutputs,"md.solidearth.requested_outputs");
	/*}}}*/

}/*}}}*/

/*Finite Element Analysis*/
void           OceantransportAnalysis::Core(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
void           OceantransportAnalysis::PreCore(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
ElementVector* OceantransportAnalysis::CreateDVector(Element* element){/*{{{*/
	/*Default, return NULL*/
	return NULL;
}/*}}}*/
ElementMatrix* OceantransportAnalysis::CreateJacobianMatrix(Element* element){/*{{{*/
_error_("Not implemented");
}/*}}}*/
ElementMatrix* OceantransportAnalysis::CreateKMatrix(Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
ElementVector* OceantransportAnalysis::CreatePVector(Element* element){/*{{{*/
_error_("not implemented yet");
}/*}}}*/
void           OceantransportAnalysis::GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element){/*{{{*/

	/*do nothing:*/
	return;

}/*}}}*/
void           OceantransportAnalysis::GradientJ(Vector<IssmDouble>* gradient,Element*  element,int control_type,int control_interp,int control_index){/*{{{*/
	_error_("Not implemented yet");
}/*}}}*/
void           OceantransportAnalysis::InputUpdateFromSolution(IssmDouble* solution,Element* element){/*{{{*/

	/*Fetch number of nodes and dof for this finite element*/
	IssmDouble time;
	IssmDouble bp[3];
	IssmDouble dsl[3];
	IssmDouble str;
	int numnodes = element->GetNumberOfNodes();
	
	element->parameters->FindParam(&time,TimeEnum);

	TriaInput* str_input=xDynamicCast<TriaInput*>(element->GetInput(OceantransportSpcstrEnum,time)); _assert_(str_input);
	TriaInput* bp_input=xDynamicCast<TriaInput*>(element->GetInput(OceantransportSpcbottompressureEnum,time)); _assert_(bp_input);
	TriaInput* dsl_input=xDynamicCast<TriaInput*>(element->GetInput(OceantransportSpcdslEnum,time)); _assert_(dsl_input);

	Gauss* gauss=element->NewGauss();
	for(int iv=0;iv<3;iv++){
		gauss->GaussVertex(iv);
		bp_input->GetInputValue(&bp[iv],gauss);
		dsl_input->GetInputValue(&dsl[iv],gauss);
	}
	str_input->GetInputAverage(&str);
	delete gauss;

	/*Add str bp and dsl levelsets as inputs to the tria element: */
	element->AddInput(BottomPressureEnum,bp,P1Enum);
	element->AddInput(DslEnum,dsl,P1Enum);
	element->AddInput(StrEnum,&str,P0Enum); 

}/*}}}*/
void           OceantransportAnalysis::UpdateConstraints(FemModel* femmodel){/*{{{*/
	/*Default, do nothing*/
	return;
}/*}}}*/
