/*!\file FrontalForcingsx
 * \brief: compute ice frontal melting rate
 */

#include "./FrontalForcingsx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Random/random.h"

void FrontalForcingsx(FemModel* femmodel){/*{{{*/

	/*Recover melt_parameterization*/
	int melt_parameterization;
	femmodel->parameters->FindParam(&melt_parameterization,FrontalForcingsParamEnum);

	/*Calculate melting rate*/
	switch(melt_parameterization){
		case FrontalForcingsDefaultEnum:
			break;
		case FrontalForcingsRignotAutoregressionEnum:
			Thermalforcingautoregressionx(femmodel);
			/*Do not break here, call IcefrontAreax(),RignotMeltParameterizationx()*/
		case FrontalForcingsRignotEnum:
			femmodel->IcefrontAreax();
			femmodel->RignotMeltParameterizationx();
			break;
		default:
			_error_("Frontal forcings "<<EnumToStringx(melt_parameterization)<<" not supported yet");
	}
}/*}}}*/
void Thermalforcingautoregressionx(FemModel* femmodel){/*{{{*/

   /*Get time parameters*/
   IssmDouble time,dt,starttime,tstep_ar;
   femmodel->parameters->FindParam(&time,TimeEnum);
   femmodel->parameters->FindParam(&dt,TimesteppingTimeStepEnum);
   femmodel->parameters->FindParam(&starttime,TimesteppingStartTimeEnum);
   femmodel->parameters->FindParam(&tstep_ar,FrontalForcingsAutoregressionTimestepEnum);

   /*Determine if this is a time step for the AR model*/
   bool isstepforar = false;

   #ifndef _HAVE_AD_
   if((fmod(time,tstep_ar)<fmod((time-dt),tstep_ar)) || (time<=starttime+dt) || tstep_ar==dt) isstepforar = true;
   #else
   _error_("not implemented yet");
   #endif

   /*Load parameters*/
	bool isstochastic;
   bool istfstochastic = false;
	int M,N,Nlagcoefs,arorder,numbasins,my_rank;
   femmodel->parameters->FindParam(&numbasins,FrontalForcingsNumberofBasinsEnum);
   femmodel->parameters->FindParam(&arorder,FrontalForcingsAutoregressiveOrderEnum);
   IssmDouble tinit_ar;
   IssmDouble* termconstant  = NULL;
   IssmDouble* trend         = NULL;
   IssmDouble* lagcoefs      = NULL;

	femmodel->parameters->FindParam(&tinit_ar,FrontalForcingsAutoregressionInitialTimeEnum);
   femmodel->parameters->FindParam(&termconstant,&M,FrontalForcingsautoregressionconstEnum);    _assert_(M==numbasins);
   femmodel->parameters->FindParam(&trend,&M,FrontalForcingsautoregressiontrendEnum);    _assert_(M==numbasins);
   femmodel->parameters->FindParam(&lagcoefs,&M,&Nlagcoefs,FrontalForcingsarlagcoefsEnum);  _assert_(M==numbasins); _assert_(Nlagcoefs==arorder);

	femmodel->parameters->FindParam(&isstochastic,StochasticForcingIsStochasticForcingEnum);
	if(isstochastic){
		int  numstochasticfields;
		int* stochasticfields;
		femmodel->parameters->FindParam(&numstochasticfields,StochasticForcingNumFieldsEnum);
		femmodel->parameters->FindParam(&stochasticfields,&N,StochasticForcingFieldsEnum); _assert_(N==numstochasticfields);
		for(int i=0;i<numstochasticfields;i++){
			if(stochasticfields[i]==FrontalForcingsRignotAutoregressionEnum) istfstochastic = true;
		}
		xDelete<int>(stochasticfields);
	}
   /*Time elapsed with respect to AR model initial time*/
   IssmDouble telapsed_ar = time-tinit_ar;

   /*Loop over each element to compute Thermal Forcing at vertices*/
   for(Object* &object:femmodel->elements->objects){
      Element* element = xDynamicCast<Element*>(object);
      element->Autoregression(isstepforar,arorder,telapsed_ar,tstep_ar,termconstant,trend,lagcoefs,istfstochastic,FrontalForcingsRignotAutoregressionEnum);
   }

   /*Cleanup*/
   xDelete<IssmDouble>(termconstant);
   xDelete<IssmDouble>(trend);
   xDelete<IssmDouble>(lagcoefs);
}/*}}}*/
