function field = get(inputlist,field_name,varargin)
%ADD - get a parameter input with name "field_name". 
%
%   Usage:
%      inputlist = get(inputlist,field_name,varargin)
%      optional argument: list of dofs being kept.
%      ex: 
%              inputlist=get(inputlist,'velocity',[1 1 0]); %only keep vx,vy
%              inputlist=get(inputlist,'velocity',[1 1 1]); %keep vx,vy,vz

field=[]; %in case we find nothing

for i=1:length(inputlist),

	if strcmpi(field_name,getname(inputlist(i).input)),

		%found the field, call the get method
		field=get(inputlist(i).input,varargin{:});
		return;
	end
end
