function inputlist = add(inputlist,field_name,field,field_type,varargin)
%ADD - add an input to parameter inputs
%
%   Usage:
%      inputlist = add(inputlist,field_name,field,field_type)

found=0;

if length(inputlist)==0,
	inputlist
	inputlist(end+1).input=inputfield(field_name,field,field_type,varargin);
else
	for i=1:length(inputlist),

		if strcmpi(field_name,getname(inputlist(i).input)),
			%replace this field by new field
			inputlist(i).input=inputfield(field_name,field,field_type,varargin{:});
			found=1;
			break;
		end
	end


	%did we find the input name?
	if found,
		%we are done
	else
		%add at the end
		inputlist(end+1).input=inputfield(field_name,field,field_type,varargin{:});
	end
end
if ~isa(inputlist,'inputlist'),
	inputlist=class(inputlist,'inputlist');
end
