function inputfield = inputfield(varargin)
%INPUTS - contructor for inputfield objects
%
%   Usage:
%      inputfield = inputfield()
%      inputfield = inputfield(name,field,field_type)

STRING=0;
INTEGER=1;
DOUBLE=2;
DOUBLEVEC=3;

switch nargin
case 0
	inputfield.name='';
	inputfield.type=DOUBLE;

	%placeholders:
	inputfield.string='';
	inputfield.integer=NaN;
	inputfield.double=NaN;
	inputfield.vector=[];
	inputfield.ndof=NaN;
	inputfield.numberofnodes=NaN;
	
	inputfield=class(inputfield,'inputfield');
	

case  3
	name=varargin{1};
	field=varargin{2};
	field_type=varargin{3};

	if ~ischar(name),
		error('in inputfield(name,field,field_type) constructor call, name is a string');
	end

	if ~ischar(field_type),
		error('in inputfield(name,field,field_type) constructor call, field_type is a string: ''string'',''integer'',''double'' or ''doublevec'' ');
	end

	inputfield.name='';
	inputfield.type=DOUBLE;

	%placeholders:
	inputfield.string='';
	inputfield.integer=NaN;
	inputfield.double=NaN;
	inputfield.vector=[];
	inputfield.ndof=NaN;
	inputfield.numberofnodes=NaN;

	%fill fields
	inputfield.name=name;
	if strcmpi(field_type,'string'),
		inputfield.type=STRING;
		inputfield.string=field;
	end

	if strcmpi(field_type,'integer'),
		inputfield.type=INTEGER;
		inputfield.integer=field;
	end

	if strcmpi(field_type,'double'),
		inputfield.type=DOUBLE;
		inputfield.double=field;
	end

	if strcmpi(field_type,'doublevec'),
		inputfield.type=DOUBLEVEC;
		inputfield.vector=field;
		inputfield.ndof=1;
		inputfield.numberofnodes=length(inputfield.vector);
	end
	inputfield=class(inputfield,'inputfield');

case  5
	name=varargin{1};
	field=varargin{2};
	field_type=varargin{3};
	ndof=varargin{4};
	numberofnodes=varargin{5};

	if ~ischar(name),
		error('in inputfield(name,field,field_type) constructor call, name is a string');
	end

	if ~ischar(field_type),
		error('in inputfield(name,field,field_type) constructor call, field_type is a string: ''string'',''integer'',''double'' or ''doublevec'' ');
	end

	inputfield.name='';
	inputfield.type=DOUBLE;

	%placeholders:
	inputfield.string='';
	inputfield.integer=NaN;
	inputfield.double=NaN;
	inputfield.vector=[];
	inputfield.ndof=NaN;
	inputfield.numberofnodes=NaN;

	%fill fields
	inputfield.name=name;
	if strcmpi(field_type,'string'),
		inputfield.type=STRING;
		inputfield.string=field;
	end

	if strcmpi(field_type,'integer'),
		inputfield.type=INTEGER;
		inputfield.integer=field;
	end

	if strcmpi(field_type,'double'),
		inputfield.type=DOUBLE;
		inputfield.double=field;
	end

	if strcmpi(field_type,'doublevec'),
		inputfield.type=DOUBLEVEC;
		inputfield.vector=field;
		inputfield.ndof=ndof;
		inputfield.numberofnodes=numberofnodes;
		if (inputfield.ndof*inputfield.numberofnodes)~=length(inputfield.vector),
			error(['length of vector ''',inputfield.name,''' should be ndof*numberofnodes=' num2str(ndof*numberofnodes)]);
		end
	end
	inputfield=class(inputfield,'inputfield');


otherwise
	error('inputfield constructor error message: 0 of 1 argument only in inputfield.');
end
