function field=get(inputfield,varargin)
%GET - returns field from inputfield 
%      usage:  
%          field=get(inputfield);
%          field=get(inputfield,doflist); %dof flag list for doublevec vectors. 
%
%          ex: velocity=get(inputfield)
%          or: velocity=get(inputfield,[1 1 0]); %get only vx and vy
%          or: velocity=get(inputfield,[1 1 1]); %get vx,vy and vz
%


STRING=0;
INTEGER=1;
DOUBLE=2;
DOUBLEVEC=3;

field=[]; %in case nothing is returned
if inputfield.type==STRING,
	field=inputfield.string;
end

if inputfield.type==INTEGER,
	field=inputfield.integer;
end

if inputfield.type==DOUBLE,
	field=inputfield.double;
end

if inputfield.type==DOUBLEVEC,
	if nargin==1,
		field=inputfield.double;
	else
		doflist=varargin{1};
		numdofs=numel(find(doflist));
		field=zeros(numdofs*inputfield.numberofnodes,1);

		count=0;
		for i=1:length(doflist),
			if doflist(i),
				count=count+1;
				field(count:numdofs:end)=inputfield.vector(i:inputfield.ndof:end);
			end
		end
	end
end
