function display(inputfield)
%DISPLAY - displays the fields of an inputfield object
%
%   echo function for 'inputfield' class

STRING=0;
INTEGER=1;
DOUBLE=2;
DOUBLEVEC=3;

if isempty(inputfield.name),
	%do nothing
	return;
end

%disp(sprintf('\n%s = \n',inputfieldname(1)));

switch inputfield.type, 
	case STRING,
		disp(sprintf('   %s(string): %s',inputfield.name,inputfield.string));
	case INTEGER,
		disp(sprintf('   %s(integer): %i',inputfield.name,inputfield.integer));
	case DOUBLE,
		disp(sprintf('   %s(double): %i',inputfield.name,inputfield.double));
	case DOUBLEVEC,
		disp(sprintf('   %s(vector): ndof %i numberofnodes %i ',inputfield.name,inputfield.ndof,inputfield.numberofnodes));
		for i=1:inputfield.numberofnodes,
			string='                  ';
			for j=1:inputfield.ndof,
				string=[string ' ' num2str(inputfield.vector((i-1)*inputfield.ndof+j))];
			end
			disp(string);
		end
end

