/*!\file: balancedthickness_core.cpp
 * \brief: core of the balancedthickness solution 
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "balancedthickness_core"

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../issm.h"

void balancedthickness_core(DataSet* results,Model* model,ParameterInputs* inputs){

	extern int my_rank;

	/*output: */
	Result* result=NULL;

	/*intermediary: */
	Vec u_g=NULL;

	/*solutions: */
	Vec h_g=NULL;

	/*flags: */
	int verbose=0;
	int numberofdofspernode;
	int numberofnodes;
	int dofs[2]={1,1};

	/*fem balancedthickness model: */
	FemModel* fem_p=NULL;


	/*recover fem model: */
	fem_p=model->GetFormulation(BalancedthicknessAnalysisEnum());

	//first recover parameters common to all solutions
	model->FindParam(&verbose,"verbose");
	model->FindParam(&numberofnodes,"numberofnodes");
	model->FindParam(&numberofdofspernode,"numberofdofspernode");

	_printf_("depth averaging velocity...\n");
	u_g=inputs->Get("velocity",&dofs[0],2); //take (vx,vy) from inputs velocity
	FieldDepthAveragex( u_g, fem_p->elements,fem_p->nodes, fem_p->loads, fem_p->materials,fem_p->parameters,"velocity");
	inputs->Add("velocity_average",u_g,2,numberofnodes);
	
	_printf_("call computational core:\n");
	diagnostic_core_linear(&h_g,fem_p,inputs,BalancedthicknessAnalysisEnum(),NoneAnalysisEnum());

	_printf_("extrude computed thickness on all layers:\n");
	FieldExtrudex( h_g, fem_p->elements,fem_p->nodes, fem_p->loads, fem_p->materials,fem_p->parameters,"thickness",0);

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"h_g",h_g);
	results->AddObject(result);

	/*Free ressources:*/
	VecFree(&u_g);
	VecFree(&h_g);
}
