function results=balancedthickness_core(models,inputs,analysis_type,sub_analysis_type)
%BALANCEDTHICKNESS_CORE - linear solution sequence
%
%   Usage:
%      h_g=balancedthickness_core(m,inputs,analysis_type,sub_analysis_type)

	%get FE model
	m=models.bt;
	results.time=0;
	results.step=1;

	displaystring(m.parameters.verbose,'\n%s',['depth averaging velocity...']);
	%Take only the first two dofs of m.parameters.u_g
	u_g=get(inputs,'velocity',[1 1 0 0]);
	u_g=FieldDepthAverage(m.elements,m.nodes,m.loads,m.materials,m.parameters,u_g,'velocity');
	inputs=add(inputs,'velocity_average',u_g,'doublevec',2,m.parameters.numberofnodes);

	displaystring(m.parameters.verbose,'\n%s',['call computational core:']);
	results.h_g=diagnostic_core_linear(m,inputs,analysis_type,sub_analysis_type);

	displaystring(m.parameters.verbose,'\n%s',['extrude computed thickness on all layers:']);
	results.h_g=FieldExtrude(m.elements,m.nodes,m.loads,m.materials,m.parameters,results.h_g,'thickness',0);

end %end function
