function md=solvebarystatic(md)

	times=md.timestepping.start_time:md.timestepping.time_step:md.timestepping.final_time;

	nt=length(times); 
	SLR=zeros(nt,1);
	VOL=zeros(nt,1);
	totalarea=zeros(nt,1);
	areas=GetAreasSphericalTria(md.mesh.elements,md.mesh.lat,md.mesh.long,planetradius('earth'));

	rho_ice=md.materials.rho_ice;
	rho_water=md.materials.rho_water;
	oceanarea=3.619e+14;

	responseice=zeros(md.mesh.numberofvertices,1);
	responseocean=zeros(md.mesh.numberofvertices,1);
	responsedh=zeros(md.mesh.numberofelements,nt-1);
	responseeus=zeros(md.mesh.numberofelements,nt-1);

	for t=1:nt-1, 
	
		time=times(t);

		%recover masks and thickness changes: 
		tdH=md.mmemasstransport.thickness(end,:);
		ind=findind(time,tdH);
		dHt=md.mmemasstransport.thickness(1:end-1,ind+1)- md.mmemasstransport.thickness(1:end-1,ind);
	
		tocean=md.mask.ocean_levelset(end,:); 
		ind=findind(time,tocean);
		ocean=md.mask.ocean_levelset(1:end-1,ind);

		tice=md.mask.ice_levelset(end,:); 
		ind=findind(time,tice);
		ice=md.mask.ice_levelset(1:end-1,ind);
		
		masks.isiceonly=isiceonly(ice(md.mesh.elements));
		masks.isoceanin=isoceanin(ocean(md.mesh.elements));
		masks.isfullyfloating=isfullyfloating(ocean(md.mesh.elements));
		masks.notfullygrounded=notfullygrounded(ocean(md.mesh.elements));

		%Go through elements and sum up: 
		pos=find(masks.isiceonly & ~masks.isfullyfloating);
		responsedh(:,t)=dHt;
		responseice(:,t)=ice;
		responseocean(:,t)=ocean;
		responseeus(:,t)=ptve(md,pos);
		SLR(t)=sum(-areas(pos).*dHt(pos)*rho_ice/(oceanarea*rho_water));

		%total area: 
		totalarea(t)=sum(areas(pos));

		%Volume too: 
		pos=find(masks.isiceonly); 
		VOL(t)=sum(-areas(pos).*dHt(pos)*rho_ice/(oceanarea*rho_water));
		%plotmodel(md,'data',masks.isiceonly,'view',[90 -90]);
		%plotmodel(md,'data',areas.*dHt.*(masks.isiceonly & ~masks.isfullyfloating),'view',[90 -90]);
		%plotmodel(md,'data',areas.*dHt.*(masks.isiceonly),'view',[90 -90]);

	end

	md.results.SLR=cumsum(SLR);
	md.results.VOL=cumsum(VOL);
	md.results.AREA=totalarea;
	md.results.responseice=responseice;
	md.results.responseocean=responseocean;
	md.results.responsedh=responsedh;
	md.results.responseeus=responseeus;
end
function ind=findind(t,ts) % {{{

	nts=length(ts);
	if t<ts(2), 
		ind=1; 
	elseif t>=ts(end), 
		ind=nts;
	end;
	for i=2:nts-1, 
		if (t>=ts(i) & t<ts(i+1)),
			ind=i;
			break;
		end
	end
end   % }}}
function flags=isiceonly(ice) % {{{
	flags=max(ice,[],2)<0.0;
end % }}}
function flag=isoceanin(ocean)% {{{
	flag=min(ocean,[],2)<0;
end% }}}
function flags=isfullyfloating(ocean)% {{{
	flags=max(ocean,[],2)<=0;
end% }}}
function flags=notfullygrounded(ocean)% {{{
	flags=zeros(length(ocean),1);
	pos=find(min(ocean,[],2)<0); 
	flags(pos)=1; 
end% }}}
