%
%  define the data to write the dakota .in file
%
%  []=dakota_in_data(variables,responses,dmeth,dparams,filei,package,varargin)
%
function []=dakota_in_data(dmeth,variables,responses,dparams,filei,package,varargin)

if ~nargin
    help dakota_in_data
    return
end

%%  parameters

%  get default set of parameters

params=dakota_in_params(struct());

%  merge specified parameters into default set, whether or not
%  they already exist

fnames=fieldnames(dparams);

for i=1:numel(fnames)
    if ~isfield(params,fnames{i})
        warning('dakota_in_data:unknown_param',...
            'No parameter ''%s'' in default parameter set.',...
            fnames{i});
    end
    params.(fnames{i})=dparams.(fnames{i});
end

if strcmpi(params.analysis_driver,'matlab') && ...
   isempty(params.analysis_components)
    [pathstr,name,ext,versn] = fileparts(filei);
    params.analysis_components=fullfile(pathstr,[name '.m' versn]);
end

%  merge method parameters, though they shouldn't be in dparams

% dmeth=dmeth_params_merge(dmeth,dparams)


%%  variables

fnames=fieldnames(variables);

for i=1:length(fnames)
    
%  for linear constraints, just copy

    if strcmp(class(variables.(fnames{i})),'linear_inequality_constraint') || ...
       strcmp(class(variables.(fnames{i})),'linear_equality_constraint'  )
        dvar.(fnames{i})=variables.(fnames{i});

%  for variables, call the setup function

    else
        fhandle=str2func([class(variables.(fnames{i})) '.empty']);
        dvar.(fnames{i})=fhandle();
        for j=1:length(variables.(fnames{i}))
            %call setupdesign
            dvar.(fnames{i})=QmuSetupDesign(dvar.(fnames{i}),variables.(fnames{i})(j),params,varargin{:}); 
        end
    end
end

%%  responses

fnames=fieldnames(responses);

for i=1:length(fnames)
%     fhandle=str2func([class(responses.(fnames{i})) '.empty']);
%     dresp.(fnames{i})=fhandle();
%     for j=1:length(responses.(fnames{i}))
%         dresp.(fnames{i})(j)=responses.(fnames{i})(j);
%     end

%  currently all response types can just be copied

    dresp.(fnames{i})=responses.(fnames{i});
end

%%  write files

%Write in file
dakota_in_write(dmeth.method,dmeth,dvar,dresp,params,filei,varargin{:});

%Write m file
dakota_m_write(dmeth.method,dmeth,dvar,dresp,params,filei,package,varargin{:});

end
