import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from processmesh import processmesh


def plot_edgeoverlay(md, datain, options, ax):
    '''
    plot_channels - plot channels area for GLADS
    Usage:
        plot_channels(md, options, fig, axes)

    See also: PLOTMODEL'''

    x, y, z, elements, is2d, isplanet = processmesh(md, [], options)

    flags = datain > 6.7e-5  # this is appropriate for channel Area (perhaps)
    hide = np.invert(flags)

    NodeMask = np.zeros(np.shape(md.mesh.x), dtype=bool)
    HideElt = md.mesh.edges[np.where(hide), 0] - 1
    NodeMask[HideElt] = True
    MaskX = np.ma.array(x, mask=NodeMask)
    MaskY = np.ma.array(y, mask=NodeMask)

    EdgeEnd = md.mesh.edges[:, 1] - 1
    EdgeStart = md.mesh.edges[:, 0] - 1
    quiverU = MaskX[EdgeEnd] - MaskX[EdgeStart]
    quiverV = MaskY[EdgeEnd] - MaskY[EdgeStart]

    Masked = np.ma.masked_array(datain, mask=hide)
    if options.exist('cedgelim'):
        lims = options.getfieldvalue('cedgelim', [Masked.min(), Masked.max()])
        edgenorm = mpl.colors.Normalize(vmin=lims[0], vmax=lims[1])
    else:
        edgenorm = mpl.colors.Normalize(vmin=Masked.min(), vmax=Masked.max())
    edgemap = plt.cm.get_cmap('inferno')

    ax.quiver(MaskX[EdgeStart], MaskY[EdgeStart], quiverU, quiverV, datain,
              units="xy", angles="xy", scale_units="xy", scale=1,
              headwidth=0, headlength=0, width=100, headaxislength=0,
              norm=edgenorm, cmap=edgemap)

    plt.colorbar(plt.cm.ScalarMappable(norm=edgenorm, cmap=edgemap), ax=ax)
