/*!\file: mmemasstransport_core.cpp
 * \brief: core of the mmemasstransport solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void SolidEarthMmemasstransportUpdates(FemModel* femmodel);
void mmemasstransport_core(FemModel* femmodel){ /*{{{*/

	/*Start profiler*/
	femmodel->profiler->Start(OCEANTRANSPORTCORE);

	/*parameters: */
	int    numoutputs;
	bool   save_results;
	bool   dakota_analysis;
	int    solution_type;
	Vector<IssmDouble>*  ug  = NULL;

	/*activate configuration*/
	femmodel->SetCurrentConfiguration(MmemasstransportAnalysisEnum);

	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	if(VerboseSolution()) _printf0_("   computing MME mass transport\n");

	/*grab delta thickness from MmemasstransportDeltathicknessEnum inputs in each element, assemble into a vector and feed to 
	 * InputUpdateFromSolutionx which will deal with accumulating such inputs:*/
	GetSolutionFromInputsx(&ug,femmodel); 
	InputUpdateFromSolutionx(femmodel,ug); 

	SolidEarthMmemasstransportUpdates(femmodel);

	if(solution_type==MmemasstransportSolutionEnum)femmodel->RequestedDependentsx();

	/*profiler*/
	femmodel->profiler->Stop(MMEMASSTRANSPORTCORE);

	/*free ressources:*/
	delete ug;

} /*}}}*/
void SolidEarthMmemasstransportUpdates(FemModel* femmodel){ /*{{{*/

	IssmDouble time;
	int frequency,count;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&time,TimeEnum);
	femmodel->parameters->FindParam(&frequency,SolidearthSettingsRunFrequencyEnum);
	femmodel->parameters->FindParam(&count,SealevelchangeRunCountEnum);

	/* Accumulate delta thikcness: */
	femmodel->inputs->AXPY(+1, DeltaThicknessEnum,AccumulatedDeltaThicknessEnum);

	/* Compute total thickness change between two sea-level solver time steps, ie. every frequency*dt. */
	if(count==frequency){
		femmodel->inputs->ZAXPY(-1, OldAccumulatedDeltaThicknessEnum,AccumulatedDeltaThicknessEnum,DeltaThicknessEnum);
		femmodel->inputs->DuplicateInput(AccumulatedDeltaThicknessEnum,OldAccumulatedDeltaThicknessEnum);
	}
	return;
}/*}}}*/
