/*!\file UpdateMmesx
 * \brief: update Mmes prior to running any core
 */

#include "./UpdateMmesx.h"
#include "../MmeToInputFromIdx/MmeToInputFromIdx.h"

void  UpdateMmesx(FemModel* femmodel){ 

	if(VerboseModule()) _printf0_("   Updating Mmes\n");

		 
	/*Deal with solid earth external: {{{*/
	if (femmodel->inputs->Exist(SolidearthExternalDisplacementEastRateEnum) && femmodel->inputs->GetInputObjectEnum(SolidearthExternalDisplacementEastRateEnum)==DatasetInputEnum){
		
		IssmDouble modelid=0;
		femmodel->parameters->FindParam(&modelid,SolidearthExternalModelidEnum);
	
		/*replace dataset of forcings with only one, the modelid'th:*/
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalDisplacementNorthRateEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalDisplacementEastRateEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalDisplacementUpRateEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalGeoidRateEnum, P1Enum);

	} /*}}}*/
	/*Deal with ocean: {{{*/
	if (femmodel->inputs->Exist(OceantransportSpcbottompressureEnum) && femmodel->inputs->GetInputObjectEnum(OceantransportSpcbottompressureEnum)==DatasetInputEnum){
		
		IssmDouble modelid=0;
		femmodel->parameters->FindParam(&modelid,DslModelidEnum);

		/*replace dataset of forcings with only one, the modelid'th:*/
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,OceantransportSpcbottompressureEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,OceantransportSpcdslEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,OceantransportSpcstrEnum, P0Enum);
	} /*}}}*/
	if (femmodel->inputs->Exist(MmemasstransportThicknessEnum) && femmodel->inputs->GetInputObjectEnum(MmemasstransportThicknessEnum)==DatasetInputEnum){ /*{{{*/
	
		/*Deal with solid earth ice loads: */

		int nids;
		IssmDouble* modelids=NULL; 
		IssmDouble* partition = NULL;

		/*retrieve partition vector and model ids necessary to resolve our thickness:*/
		femmodel->parameters->FindParam(&modelids,&nids,NULL,MmemasstransportModelidsEnum);
		femmodel->parameters->FindParam(&partition,NULL,NULL,MmemasstransportPartitionEnum);

		MmeToInput(femmodel,modelids,partition,nids,MmemasstransportThicknessEnum, P0Enum);

		if (femmodel->inputs->GetInputObjectEnum(MaskIceLevelsetEnum)==DatasetInputEnum)
			MmeToInput(femmodel,modelids,partition,nids,MaskIceLevelsetEnum, P1Enum);

		if (femmodel->inputs->GetInputObjectEnum(MaskOceanLevelsetEnum)==DatasetInputEnum)
			MmeToInput(femmodel,modelids,partition,nids,MaskOceanLevelsetEnum, P1Enum);

		/*free ressources:*/
		xDelete<IssmDouble>(modelids);
		xDelete<IssmDouble>(partition);


	} /*}}}*/
} 
	
