#include "./MmemasstransporttransportAnalysis.h"
#include <math.h>
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../classes/Inputs/TransientInput.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
void MmemasstransporttransportAnalysis::CreateConstraints(Constraints* constraints,IoModel* iomodel){/*{{{*/
	/*No constraints*/
}/*}}}*/
void MmemasstransporttransportAnalysis::CreateLoads(Loads* loads, IoModel* iomodel){/*{{{*/
	/*No loads*/
}/*}}}*/
void MmemasstransporttransportAnalysis::CreateNodes(Nodes* nodes,IoModel* iomodel,bool isamr){/*{{{*/
	::CreateNodes(nodes,iomodel,MmemasstransporttransportAnalysisEnum,P1Enum);
}/*}}}*/
int  MmemasstransporttransportAnalysis::DofsPerNode(int** doflist,int domaintype,int approximation){/*{{{*/
	return 3;
}/*}}}*/
void MmemasstransporttransportAnalysis::UpdateElements(Elements* elements,Inputs* inputs,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	int  nature=0;
	bool isdakota=0;

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(inputs,i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	/*Plug inputs into element:*/
	iomodel->FetchDataToInput(inputs,elements,"md.mmemasstransport.deltathickness", MmemasstransportDeltathicknessEnum);

	/*Initialize sea level cumulated sea level loads :*/
	iomodel->ConstantToInput(inputs,elements,0.,AccumulatedDeltaThicknessEnum,P0Enum);
	iomodel->ConstantToInput(inputs,elements,0.,OldAccumulatedDeltaThicknessEnum,P0Enum);

}/*}}}*/
void MmemasstransporttransportAnalysis::UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/

	int     numoutputs;
	char**  requestedoutputs = NULL;

	/*Deal with multi-model ensembles: {{{*/

	int nids,npart,nel;
	IssmDouble* modelids=NULL; 
	IssmDouble* partition = NULL;

	iomodel->FetchData(&nel,"md.mesh.numberofelements");
	iomodel->FetchData(&modelids,&nids,NULL,"md.mmemasstransport.modelids");
	parameters->AddObject(new DoubleParam(MmemasstransportModelidsEnum,modelids,nids,1));
	iomodel->FetchData(&partition,&npart,NULL,"md.mmemasstransport.partition");
	if (npart!=nel)_error_("MmemasstransportAnalysis:UpdateParameters: partition vector should be distributed over elements, not vertices!");
	parameters->AddObject(new DoubleParam(MmemasstransportPartitionEnum,partition,nel,1));
	
	xDelete<IssmDouble>(modelids);
	xDelete<IssmDouble>(partition);

	} /*}}}*/
	/*Requested outputs {{{*/
	iomodel->FindConstant(&requestedoutputs,&numoutputs,"md.solidearth.requested_outputs");
	if(numoutputs)parameters->AddObject(new StringArrayParam(SealevelchangeRequestedOutputsEnum,requestedoutputs,numoutputs));
	iomodel->DeleteData(&requestedoutputs,numoutputs,"md.solidearth.requested_outputs");
	/*}}}*/

}/*}}}*/

/*Finite Element Analysis*/
void           MmemasstransporttransportAnalysis::Core(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
void           MmemasstransporttransportAnalysis::PreCore(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
ElementVector* MmemasstransporttransportAnalysis::CreateDVector(Element* element){/*{{{*/
	/*Default, return NULL*/
	return NULL;
}/*}}}*/
ElementMatrix* MmemasstransporttransportAnalysis::CreateJacobianMatrix(Element* element){/*{{{*/
_error_("Not implemented");
}/*}}}*/
ElementMatrix* MmemasstransporttransportAnalysis::CreateKMatrix(Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
ElementVector* MmemasstransporttransportAnalysis::CreatePVector(Element* element){/*{{{*/
_error_("not implemented yet");
}/*}}}*/
void           MmemasstransporttransportAnalysis::GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element){/*{{{*/

	/*retrieve thickness from MmemasstransporttransportAnalysis spcs in our element:*/

	IssmDouble h;
	int       *doflist = NULL;

	/*Fetch number of nodes and initialize values*/
	int         numnodes = element->GetNumberOfNodes();
	int         numdof   = numnodes;
	IssmDouble* values   = xNew<IssmDouble>(numdof);

	/*Get dof list and inputs */
	element->GetDofList(&doflist,NoneApproximationEnum,GsetEnum);
	Input* dh_input=element->GetInput(MmemasstransportDeltathicknessEnum); _assert_(h_input);

	/*Ok, we have the thickness in inputs, fill in solution */
	Gauss* gauss=element->NewGauss();
	for(int i=0;i<numnodes;i++){
		gauss->GaussVertex(i);
		dh_input->GetInputValue(&dh,gauss);
		values[i+0]=dh;
	}

	/*Add value to global vector*/
	solution->SetValues(numdof,doflist,values,INS_VAL);

	/*Free ressources:*/
	delete gauss;
	xDelete<int>(doflist);
	xDelete<IssmDouble>(values);
}/*}}}*/
void           MmemasstransporttransportAnalysis::GradientJ(Vector<IssmDouble>* gradient,Element*  element,int control_type,int control_interp,int control_index){/*{{{*/
	_error_("Not implemented yet");
}/*}}}*/
void           MmemasstransporttransportAnalysis::InputUpdateFromSolution(IssmDouble* solution,Element* element){/*{{{*/

	int         i,domaintype;
	int*        doflist=NULL;

	/*Fetch number of nodes and dof for this finite element*/
	int numnodes = element->GetNumberOfNodes();
	int numdof   = numnodes;

	/*Fetch dof list and allocate solution vectors*/
	element->GetDofListLocal(&doflist,NoneApproximationEnum,GsetEnum);
	IssmDouble* values    = xNew<IssmDouble>(numdof);
	IssmDouble* h        = xNew<IssmDouble>(numnodes);

	/*Use the dof list to index into the solution vector: */
	for(i=0;i<numdof;i++) values[i]=solution[doflist[i]];

	/*Retrieve h:*/
	for(i=0;i<numnodes;i++){
		h[i]=values[i+0];

		/*Check solution*/
		if(xIsNan<IssmDouble>(h[i])) _error_("NaN found in bottom pressure solution vector");
		if(xIsInf<IssmDouble>(h[i])) _error_("Inf found in bottom pressure  solution vector");
	}

	/*Add bp, dsl and str as inputs to the tria element: */
	element->AddInput(ThicknessEnum,h,P1Enum);

	/*Free ressources:*/
	xDelete<IssmDouble>(h);
	xDelete<IssmDouble>(values);
	xDelete<int>(doflist);

}/*}}}*/
void           MmemasstransporttransportAnalysis::UpdateConstraints(FemModel* femmodel){/*{{{*/
	/*Default, do nothing*/
	return;
}/*}}}*/
