/*!\file UpdateMmesx
 * \brief: update Mmes prior to running any core
 */

#include "./UpdateMmesx.h"
#include "../MmeToInputFromIdx/MmeToInputFromIdx.h"

void  UpdateMmesx(FemModel* femmodel){ 

	if(VerboseModule()) _printf0_("   Updating Mmes\n");

	IssmDouble modelid=0;
		 
	/*Deal with solid earth: */
	if (femmodel->inputs->Exist(SolidearthExternalDisplacementEastRateEnum) && femmodel->inputs->GetInputObjectEnum(SolidearthExternalDisplacementEastRateEnum)==DatasetInputEnum){
		femmodel->parameters->FindParam(&modelid,SolidearthExternalModelidEnum);

		/*replace dataset of forcings with only one, the modelid'th:*/
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalDisplacementNorthRateEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalDisplacementEastRateEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalDisplacementUpRateEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,SolidearthExternalGeoidRateEnum, P1Enum);

	}
	/*Deal with ocean: */
	if (femmodel->inputs->Exist(OceantransportSpcbottompressureEnum) && femmodel->inputs->GetInputObjectEnum(OceantransportSpcbottompressureEnum)==DatasetInputEnum){
		femmodel->parameters->FindParam(&modelid,DslModelidEnum);

		/*replace dataset of forcings with only one, the modelid'th:*/
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,OceantransportSpcbottompressureEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,OceantransportSpcdslEnum, P1Enum);
		MmeToInputFromIdx(femmodel->inputs,femmodel->elements,femmodel->parameters,modelid-1,OceantransportSpcstrEnum, P0Enum);
	}
} 
	
