function md=solvebarystatic2(md)

	times=md.timestepping.start_time:md.timestepping.time_step:md.timestepping.final_time;
	nt=length(times); 
	SLR=zeros(nt,1);
	areas=GetAreas3DTria(md.mesh.elements,md.mesh.x,md.mesh.y,md.mesh.z);

	rho_ice=md.materials.rho_ice;
	rho_water=md.materials.rho_water;
	oceanarea=3.619e+14;

	for t=1:nt-1, 
	
	    dHt=md.results.TransientSolution(t).SurfaceloadIceThicknessChange;
		
		SLR(t)=sum(-areas.*dHt)*rho_ice/(oceanarea*rho_water);
	end

	md.results.SLR=cumsum(SLR);
end
