function avg=oceanaverage(md,oceanlevelset,field)

	oceanel=isoceanin(oceanlevelset(md.mesh.elements));
	areas=GetAreasSphericalTria(md.mesh.elements,md.mesh.lat,md.mesh.long,planetradius('earth'));
	pos=find(oceanel);
	totalarea=sum(areas(pos));

	if length(field)==md.mesh.numberofelements,
		avg=sum(field(pos).*areas(pos))/totalarea;
	elseif length(field)==md.mesh.numberofvertices,
		avg=sum(field(md.mesh.elements(pos,:))*[1;1;1]/3.*areas(pos))/totalarea;
	else error('field should be of size number of elements or numbrer of vertices');
	end

end
function flag=isoceanin(ocean)% {{{
	flag=min(ocean,[],2)<0;
end% }}}
