#!/bin/bash
set -eu

## Constants
VER="3.17.1"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://ftp.mcs.anl.gov/pub/petsc/release-snapshots/petsc-lite-${VER}.tar.gz" "petsc-${VER}.tar.gz"

# Unpack source
tar -zxvf petsc-${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv petsc-${VER}/* src/
rm -rf petsc-${VER}

# Configure
#
# NOTE:
# - Cannot use --with-fpic option when compiling static libs,
#
#		Cannot determine compiler PIC flags if shared libraries is turned off
#		Either run using --with-shared-libraries or --with-pic=0 and supply the
#		compiler PIC flag via CFLAGS, CXXXFLAGS, and FCFLAGS
#
# - Added -fallow-argument-mismatch to FFLAGS in order to clear,
#
#		error: The Fortran compiler gfortran will not compile files that call 
#		the same routine with arguments of different types.
#
#	for gfortran 10 or later (may need to remove it for earlier versions).
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/petsc/install" \
	--PETSC_DIR="${ISSM_DIR}/externalpackages/petsc/src" \
	--LDFLAGS="-Wl,-no_compact_unwind" \
	--with-shared-libraries=0 \
	--CFLAGS="-fPIC" \
	--CXXFLAGS="-fPIC" \
	--FFLAGS="-fPIC" \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--download-fblaslapack=1 \
	--download-mpich=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-scalapack=1 \
	--download-mumps=1 \
	--download-zlib=1 

# Compile and install
make
make install
