#include "./LoveAnalysis.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
void LoveAnalysis::CreateConstraints(Constraints* constraints,IoModel* iomodel){/*{{{*/
}/*}}}*/
void LoveAnalysis::CreateLoads(Loads* loads, IoModel* iomodel){/*{{{*/
}/*}}}*/
void LoveAnalysis::CreateNodes(Nodes* nodes,IoModel* iomodel,bool isamr){/*{{{*/
}/*}}}*/
int  LoveAnalysis::DofsPerNode(int** doflist,int domaintype,int approximation){/*{{{*/
	_error_("not needed!");
}/*}}}*/
void LoveAnalysis::UpdateElements(Elements* elements,Inputs* inputs,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

}/*}}}*/
void LoveAnalysis::UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/
	IssmDouble* frequencies = NULL;
	int         nfreq;
	iomodel->FetchData(&nfreq,"md.love.nfreq");
	iomodel->FetchData(&frequencies,NULL,NULL,"md.love.frequencies");
	parameters->AddObject(new DoubleVecParam(LoveFrequenciesEnum,frequencies,nfreq));
	xDelete<IssmDouble>(frequencies);

	parameters->AddObject(iomodel->CopyConstantObject("md.love.nfreq",LoveNfreqEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.sh_nmax",LoveShNmaxEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.sh_nmin",LoveShNminEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.g0",LoveG0Enum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.r0",LoveR0Enum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.mu0",LoveMu0Enum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.Gravitational_Constant",LoveGravitationalConstantEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.chandler_wobble",LoveChandlerWobbleEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.allow_layer_deletion",LoveAllowLayerDeletionEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.underflow_tol",LoveUnderflowTolEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.pw_threshold",LovePostWidderThresholdEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.integration_steps_per_layer",LoveIntStepsPerLayerEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.istemporal",LoveIsTemporalEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.n_temporal_iterations",LoveNTemporalIterationsEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.love_kernels",LoveKernelsEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.forcing_type",LoveForcingTypeEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.inner_core_boundary",LoveInnerCoreBoundaryEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.core_mantle_boundary",LoveCoreMantleBoundaryEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.complex_computation",LoveComplexComputationEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.solidearth.rotational.equatorialmoi",RotationalEquatorialMoiEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.solidearth.rotational.polarmoi",RotationalPolarMoiEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.solidearth.rotational.angularvelocity",RotationalAngularVelocityEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.solidearth.lovenumbers.tk2secular",TidalLoveK2SecularEnum));
}/*}}}*/
void LoveAnalysis::UpdateConstraints(FemModel* femmodel){/*{{{*/
	/*Default, do nothing*/
	return;
}/*}}}*/

/*Finite Element Analysis*/
void           LoveAnalysis::Core(FemModel* femmodel){/*{{{*/
	_error_(" not needed!");
}/*}}}*/
void           LoveAnalysis::PreCore(FemModel* femmodel){/*{{{*/
	_error_(" not needed!");
}/*}}}*/
ElementVector* LoveAnalysis::CreateDVector(Element* element){/*{{{*/
	_error_(" not needed!");
}/*}}}*/
ElementMatrix* LoveAnalysis::CreateJacobianMatrix(Element* element){/*{{{*/
	_error_(" not needed!");
}/*}}}*/
ElementMatrix* LoveAnalysis::CreateKMatrix(Element* element){/*{{{*/
	_error_(" not needed!");
}/*}}}*/
ElementVector* LoveAnalysis::CreatePVector(Element* element){/*{{{*/
	_error_("not supported");
}/*}}}*/
void           LoveAnalysis::GetB(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss){/*{{{*/
	_error_("not supported");
}/*}}}*/
void           LoveAnalysis::GetBprime(IssmDouble* Bprime,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss){/*{{{*/
	_error_("not supported");
}/*}}}*/
void           LoveAnalysis::GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element){/*{{{*/
	   _error_("not implemented yet");
}/*}}}*/
void           LoveAnalysis::GradientJ(Vector<IssmDouble>* gradient,Element*  element,int control_type,int control_interp,int control_index){/*{{{*/
	_error_("Not implemented yet");
}/*}}}*/
void           LoveAnalysis::InputUpdateFromSolution(IssmDouble* solution,Element* element){/*{{{*/
	_error_("not supported");
}/*}}}*/
