function md=tres(md,string)
%TRES - transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%
%    Example: md=tres(md,'diagnostic');
%             md=tres(md,'control');

if strcmpi(string,'diagnostic'),
	md.vx=md.results.diagnostic.vx;
	md.vy=md.results.diagnostic.vy;
	if isfield(md.results.diagnostic,'vz'),
		md.vz=md.results.diagnostic.vz;
	end
	md.vel=md.results.diagnostic.vel;
	if isfield(md.results.diagnostic,'pressure'),
		md.pressure=md.results.diagnostic.pressure;
	end
	if md.numrifts,
		if isfield(md.results.diagnostic,'riftproperties'),
			md.riftproperties=md.results.diagnostic.riftproperties;
		end
	end
	if md.control_analysis==1,
		md.(md.results.diagnostic.control_type)=md.results.diagnostic.parameter;
	end
elseif strcmpi(string,'dakota'),
	md.dakotaresults=md.results.dakota;
elseif strcmpi(string,'steadystate'),
	md.vx=md.results.steadystate.vx;
	md.vy=md.results.steadystate.vy;
	if isfield(md.results.diagnostic,'vz'),
		md.vz=md.results.steadystate.vz;
	end

	md.vel=md.results.steadystate.vel;
	md.pressure=md.results.steadystate.pressure;
	md.temperature=md.results.steadystate.temperature;
	md.melting=md.results.steadystate.melting;
elseif strcmpi(string,'thermal'),
	md.temperature=md.results.thermal.temperature;
	md.melting=md.results.thermal.melting;
else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
