%CALVINGPARAMETERIZATION class definition
%	For test calving laws and coefficients
%   Usage:
%      calvingparameterization=calvingparameterization();

classdef calvingparameterization
	properties (SetAccess=public) 
		stress_threshold_groundedice = 0.;
		stress_threshold_floatingice = 0.;
		min_thickness = 0.;
		use_param = 0;
		scale_theta = 0.;
		amp_alpha = 0;
		midp = 0;
		nonlinearlaw = 0;
	end
	methods
		function self = calvingparameterization(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				case 1
					inputstruct=varargin{1};
					list1 = properties('calvingparameterization');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							self.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{
		end % }}}
		function self = setdefaultparameters(self) % {{{

			%Default sigma max
			self.stress_threshold_groundedice = 1e6;
			self.stress_threshold_floatingice = 150e3;

			%For now we turn this off by setting the threshold to 0
			self.min_thickness = 0.;

			%parameters for the spatial temporal seperation 
			%The coefficient follows: \gamma = \frac{\theta}{2}(1-\tanh(\frac{b+p}{\alpha}))+(1-\theta)
			% 0 - Use bed elevation, 1 - use heigh above floatation
			self.use_param = 0;
			% between 0 and 1, larger theta means more reduction for shallower ice
			self.scale_theta = 0;
			% alpha in the denominator
			self.amp_alpha = 0;
			% mid-point of this step function
			self.midp = 0;
			% if use a nonlinear calving law
			self.nonlinearlaw = 0;
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			%Early return
			if (~strcmp(solution,'TransientSolution') | md.transient.ismovingfront==0), return; end

			md = checkfield(md,'fieldname','calving.stress_threshold_groundedice','>',0,'nan',1,'Inf',1);
			md = checkfield(md,'fieldname','calving.stress_threshold_floatingice','>',0,'nan',1,'Inf',1);
			md = checkfield(md,'fieldname','calving.min_thickness','>=',0,'NaN',1,'Inf',1,'numel',1);
			md = checkfield(md,'fieldname','calving.use_param','values',[-1, 0, 1, 2, 3, 4]);
			md = checkfield(md,'fieldname','calving.scale_theta','NaN',1,'Inf',1,'numel',1);
			md = checkfield(md,'fieldname','calving.amp_alpha','<>',0,'NaN',1,'Inf',1,'numel',1);
			md = checkfield(md,'fieldname','calving.midp','NaN',1,'Inf',1,'numel',1);
			md = checkfield(md,'fieldname','calving.nonlinearlaw','values',[0, 1]);
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   Calving test parameters:'));
			fielddisplay(self,'stress_threshold_groundedice','sigma_max applied to grounded ice only [Pa]');
			fielddisplay(self,'stress_threshold_floatingice','sigma_max applied to floating ice only [Pa]');
			fielddisplay(self,'min_thickness','minimum thickness below which no ice is allowed [m]');
			fielddisplay(self,'use_param','0 - Use bed elevation, 1 - use heigh above floatation, 2 - use ice thickness');
			fielddisplay(self,'scale_theta','larger than 0, larger theta means more reduction for shallower ice');
			fielddisplay(self,'amp_alpha','alpha');
			fielddisplay(self,'midp','mid-point');
			fielddisplay(self,'nonlinearlaw','use a nonlinear law');

		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			yts=md.constants.yts;
			WriteData(fid,prefix,'name','md.calving.law','data',9,'format','Integer');
			WriteData(fid,prefix,'object',self,'fieldname','stress_threshold_groundedice','format','DoubleMat','mattype',1);
			WriteData(fid,prefix,'object',self,'fieldname','stress_threshold_floatingice','format','DoubleMat','mattype',1);
			WriteData(fid,prefix,'object',self,'fieldname','min_thickness','format','Double');
			WriteData(fid,prefix,'object',self,'fieldname','use_param','format','Integer');
			WriteData(fid,prefix,'object',self,'fieldname','scale_theta','format','Double');
			WriteData(fid,prefix,'object',self,'fieldname','amp_alpha','format','Double');
			WriteData(fid,prefix,'object',self,'fieldname','midp','format','Double');
			WriteData(fid,prefix,'object',self,'fieldname','nonlinearlaw','format','Integer');
		end % }}}
	end
end
