%
%  populate a Dakota parameter structure.
%
%  [params]=dakota_in_params(params)
%
function [params]=dakota_in_params(params)

if ~nargin
    help dakota_in_params
    return
end

%%  process the input parameters

if ~exist('params','var')
    params=struct();
end

%%  strategy section

if ~isfield(params,'graphics')
    params.graphics=false;
end
if ~isfield(params,'tabular_graphics_data')
    params.tabular_graphics_data=true;
end
% could use unique file name rather than dakota default
if ~isfield(params,'tabular_graphics_file')
    params.tabular_graphics_file='dakota_tabular.dat';
end

%%  method section

%  nearly all method parameters are in the dakota_method class
%  or result from the response level lists

if ~isfield(params,'distribution')
    params.distribution='cumulative';
end

%%  model section

%%  interface section

if ~isfield(params,'system')
    params.system=false;
end
if ~isfield(params,'fork')
    params.fork=false;
end
if ~isfield(params,'direct')
    params.direct=false;
end
if ~params.system && ~params.fork && ~params.direct
    params.fork=true;
end
if ~isfield(params,'asynchronous')
    params.asynchronous=true;
end
if ~isfield(params,'evaluation_concurrency')
    params.evaluation_concurrency=false;
end
if ~isfield(params,'analysis_driver')
    params.analysis_driver='';
end
if ~isfield(params,'analysis_components')
    params.analysis_components='';
end
if ~isfield(params,'parameters_file')
    params.parameters_file='params.in';
end
if ~isfield(params,'results_file')
    params.results_file='results.out';
end
if ~isfield(params,'file_tag')
    params.file_tag=true;
end
if ~isfield(params,'file_save')
    params.file_save=true;
end

%%  responses section

if ~isfield(params,'numerical_gradients')
    params.numerical_gradients=true;
end
if ~isfield(params,'method_source')
    params.method_source='dakota';
end
if ~isfield(params,'interval_type')
    params.interval_type='forward';
end
if ~isfield(params,'fd_gradient_step_size')
    params.fd_gradient_step_size=0.001;
end
if ~isfield(params,'analytic_gradients')
    params.analytic_gradients=false;
end
%  mixed_gradients not fully implemented
if ~isfield(params,'mixed_gradients')
    params.mixed_gradients=false;
end
if ~isfield(params,'id_analytic_gradients')
    params.id_analytic_gradients=false;
end
if ~isfield(params,'id_numerical_gradients')
    params.id_numerical_gradients=false;
end
%  hessians not fully implemented
if ~isfield(params,'numerical_hessians')
    params.numerical_gradients=true;
end
if ~isfield(params,'hessian_gradient_step_size')
    params.fd_gradient_step_size=0.001;
end

end

