clear, close all
pn='~/mitgcm/slr/components/issm/trunk-jpl/test/NightlyRun/run/';
figure(1), clf, orient tall, wysiwyg
for ts=0:4
    r1=readbin([pn 'R_shelfIce1_' myint2str(ts+1,10) '.data'],[3 200]);
    r2=readbin([pn 'R_shelfIce2_' myint2str(ts,10) '.data'],[3 200]);
    subplot(5,1,ts+1), mypcolor(r2-r1); colorbar
end

figure(2), orient tall, wysiwyg
for ts=1:5
    e=readbin([pn 'Eta.' myint2str(ts,10) '.data'],[3 200]);
    p=readbin([pn 'PHL.' myint2str(ts,10) '.data'],[3 200]);
    f=readbin([pn 'SHICE_fwFlux.' myint2str(ts,10) '.data'],[3 200]);
    h=readbin([pn 'SHICE_heatFlux.' myint2str(ts,10) '.data'],[3 200]);
    ph=readbin([pn 'PH.' myint2str(ts,10) '.data'],[3 200 90]);
    clf, subplot(511), mypcolor(e); title(['Eta @ ts=' int2str(ts)]), colorbar
    subplot(512), mypcolor(p); title('PHL'), colorbar
    subplot(513), mypcolor(f); title('SHICE fwFlux'), colorbar
    subplot(514), mypcolor(h); title('SHICE heatFlux'), colorbar
    subplot(515), mypcolor(1:200,-1:-1:-90,squeeze(ph(2,:,:))'); title('PH'), colorbar
    pause
end
