function plot_rifpenetration(md,options,width,i);
%PLOT_RIFTPENETRATION - plot rift penetration
%
%   Usage:
%      plot_rifpenetration(md,options,width,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,options);

subplot(width,width,i); 
hold on

%plot mesh boundaries
for i=1:size(md.segments,1),
	plot(x(md.segments(i,1:2)),y(md.segments(i,1:2)),'k.-');
end

isp1=0;
isp2=0;

if isstruct(md.rifts),
	%plot mesh boundaries
	for i=1:size(md.segments,1),
		h1=plot(x(md.segments(i,1:2)),y(md.segments(i,1:2)),'b-');
	end
	for i=1:size(md.rifts,1),
		penaltypairs=md.rifts(i).penaltypairs;

		segments=md.rifts(i).segments;
		for j=1:size(segments,1),
			plot(x(segments(j,1:2)),y(segments(j,1:2)),'b-');
		end

		normal=zeros(2,1);
		for j=1:size(penaltypairs,1),
			normal(1)=penaltypairs(j,5);
			normal(2)=penaltypairs(j,6);

			vx1=md.vx(penaltypairs(j,1)); 
			vx2=md.vx(penaltypairs(j,2));
			vy1=md.vy(penaltypairs(j,1)); 
			vy2=md.vy(penaltypairs(j,2));
			penetration=(vx2-vx1)*normal(1)+(vy2-vy1)*normal(2);
			%if penetration is negative, plot in black, positive, plot in red;: ie: if rift is closing, black, if rift is opening, red.
			if(penetration>0),
				p2=plot(x(penaltypairs(j,1)) ,y(penaltypairs(j,1)),'r*');
				isp2=1;
			else
				p1=plot(x(penaltypairs(j,1)) ,y(penaltypairs(j,1)),'k*');
				isp1=1;
			end
		end

		%point out the tips
		h2=plot(x(md.rifts(i).tips(1)),y(md.rifts(i).tips(1)),'g*');
		plot(x(md.rifts(i).tips(2)),y(md.rifts(i).tips(2)),'g*');
	end
	if isp1 & isp2
		legend([h1,h2,p1,p2],'mesh boundaries','rift tips',' rifts closing','rifts opening')
	elseif isp1
		legend([h1,h2,p1],'mesh boundaries','rift tips',' rifts closing')
	elseif isp2
		legend([h1,h2,p2],'mesh boundaries','rift tips','rifts opening')
	else
		legend([h1,h2],'mesh boundaries','rift tips')
	end
else
	error('plot error message: no rifts available!');
end
hold off

%apply options
options=addfielddefault(options,'title','Rift Penetration');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
