#!/bin/bash
set -eu


# Constants
#
VER="1.10.0"
HDF5_ROOT="${ISSM_DIR}/externalpackages/petsc/install"
NETCDF_ROOT="${ISSM_DIR}/externalpackages/petsc/install"
PROJ_ROOT="${ISSM_DIR}/externalpackages/proj/install"

# Cleanup
rm -rf install src
mkdir install src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/gdal-${VER}.tar.gz" "gdal-${VER}.tar.gz"

# Unpack source
tar -zxvf gdal-${VER}.tar.gz

# Move source into 'src' directory
mv gdal-${VER}/* src
rm -rf gdal-${VER}

# Copy customized source files to 'src' directory
cp configs/1.10/linux/debian/frmts/wms/dataset.cpp src/frmts/wms
cp configs/1.10/linux/debian/ogr/ogrsf_frmts/vfk/vfkfeature.cpp src/ogr/ogrsf_frmts/vfk
cp configs/1.10/linux/debian/port/cplkeywordparser.cpp src/port

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/gdal/install" \
	--with-hdf5="${HDF5_ROOT}" \
	--with-netcdf="${NETCDF_ROOT}" \
	--with-proj="${PROJ_ROOT}"

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi

# Return to initial directory
cd ..
