function plot_rifts(md,options,width,i);
%PLOT_RIFTVEL - plot rifts in a mesh
%
%   Usage:
%      plot_rifts(md,options,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%units
if exist(options,'unit'),
	unit=getfieldvalue(options,'unit');
	md.x=md.x*unit;
	md.y=md.y*unit;
	md.z=md.z*unit;
end

if exist(options,'offset'),
	offset=getfieldvalue(options,'offset');
else
	offset=500;
end


%plot rifts
hold on;

isp1=0;
isp2=0;
			
%offset to separate rift flanks.

if isstruct(md.rifts),
	
	for i=1:size(md.rifts,1),
		penaltypairs=md.rifts(i).penaltypairs;

		normal=zeros(2,1);
		for j=1:size(penaltypairs,1),
			normal(1)=penaltypairs(j,5);
			normal(2)=penaltypairs(j,6);
			md.x(penaltypairs(j,1))=md.x(penaltypairs(j,1))-normal(1)*offset;
			md.y(penaltypairs(j,1))=md.y(penaltypairs(j,1))-normal(2)*offset;
		end
	end
end

%process data and model
[x y z elements is2d]=processmesh(md,options);

%plot mesh
subplot(width,width,i); 

%plot mesh
if is2d
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
else
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
end


%apply options
options=addfielddefault(options,'title','Rifts');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
