function plot_manager(md,options,width,i);
%PLOT__MANAGER - distribute the plots, called by plotmodel
%
%   Usage:
%      plot_manager(md,options,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT

%parse options and get a structure of options. 
options=checkplotoptions(md,options);

%get data to be displayed
data=getfieldvalue(options,'data');

%figure out if this is a special plot
if ischar(data),

	switch data,

		case 'boundaries',
			plot_boundaries(md,options,width,i);
			return;
		case 'elementnumbering',
			plot_elementnumbering(md,options,width,i);
			return;
		case 'highlightelements',
			plot_highlightelements(md,options,width,i);
			return;
		case 'segmentnumbering',
			plot_segmentnumbering(md,options,width,i);
			return;
		case 'histnorm',
			plot_qmuhistnorm(md,options,width,i);
			return;
		case 'elements_type',
			plot_elementstype(md,options,width,i);
			return;
		case 'gridnumbering',
			plot_gridnumbering(md,options,width,i);
			return;
		case 'highlightgrids',
			plot_highlightgrids(md,options,width,i);
			return;
		case {'basal_drag','basal_dragx','basal_dragy'},
			plot_basaldrag(md,options,width,i,data);
			return;
		case 'driving_stress',
			plot_drivingstress(md,options,width,i);
			return;
		case 'mesh',
			plot_mesh(md,options,width,i);
			return;
		case 'penalties',
			plot_penalties(md,options,width,i);
			return;
		case 'riftvel',
			plot_riftvel(md,options,width,i);
			return;
		case 'rifts',
			plot_rifts(md,options,width,i);
			return;
		case 'riftrelvel',
			plot_riftrelvel(md,options,width,i);
			return;
		case 'riftpenetration',
			plot_riftpenetration(md,options,width,i);
			return;
		case 'riftfraction',
			plot_riftfraction(md,options,width,i);
			return;
		case 'sarpwr',
			plot_sarpwr(md,options,width,i)
			return
		case 'pressureload'
			plot_pressureload(md,options,width,i,data)
			return
		case 'segments'
			plot_segments(md,options,width,i,data)
			return
		case {'strainrate_tensor','strainrate','strainrate_principal','strainrate_principalaxis1','strainrate_principalaxis2','strainrate_principalaxis3',...
				'stress_tensor','stress','stress_principal','stress_principalaxis1','stress_principalaxis2','stress_principalaxis3',...
				'deviatoricstress_tensor','deviatoricstress','deviatoricstress_principal','deviatoricstress_principalaxis1','deviatoricstress_principalaxis2','deviatoricstress_principalaxis3'},
			plot_tensor(md,options,width,i,data);
			return;
		case 'thermaltransient_results',
			plot_thermaltransient_results(md,options,width,i);
			return;
		case 'transient_movie',
			plot_transient_movie(md,options,width,i);
			return;
		case 'transient_results',
			plot_transient_results(md,options,width,i);
		case {'transient_thickness','transient_bed','transient_surface','transient_temperature','transient_melting','transient_vel','transient_vx','transient_vy','transient_vz','transient_pressure'}
			plot_transient_field(md,options,width,i,data);
			return;

	otherwise,

		if isfield(struct(md),data)
			data=eval(['md.' data ';']);
		else
			error('plot error message: data provided not supported yet. Type plotdoc for help');
		end
	end
end

%Figure out if this is a semi-transparent plot.
if exist(options,'overlay'),
	plot_overlay(md,data,options,width,i);
	return;
end

%Figure out if this is a Section plot
if exist(options,'sectionvalue')
	plot_section(md,data,options,width,i);
	return;
end

%process data and model
[x y z elements is2d]=processmesh(md,options);
[data2 isongrid isquiver]=processdata(md,data,options);

%standard plot:
subplot(width,width,i);
plot_unit(x,y,z,elements,data2,isongrid,is2d,isquiver,options);

%apply all options
if isquiver
	options=changefieldvalue(options,'colorbar',2);
end
if isquiver & exist(options,'contourlevels'),
	data2=data;
end
applyoptions(md,data2,options);
