function md=qmu(md,package,varargin)
%INPUT function md=qmu(md,package)
%Deal with coupled ISSM or Cielo/ Dakota runs, to do sensitivity analyses.

global ISSM_DIR;

% qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
qmudir ='qmu';
%  qmufile can not be changed unless cielo_ice_script.sh is
qmufile='qmu';
ivar   =1;
iresp  =1;
imethod=1;
iparams=1;

%  process any extra input arguments

for i=1:2:nargin-2
    switch varargin{i}
        case 'qmudir'
            qmudir =varargin{i+1};
        case 'qmufile'
            qmufile=varargin{i+1};
        case 'ivar'
            ivar   =varargin{i+1};
        case 'iresp'
            iresp  =varargin{i+1};
        case 'imethod'
            imethod=varargin{i+1};
        case 'iparams'
            iparams=varargin{i+1};
    end
end

%first create temporary directory in which we will work
if exist(qmudir,'dir')
    overwrite=input(['Overwrite existing ''' qmudir ''' directory? Y/N [N]: '], 's');
    if strncmpi(overwrite,'y',1)
        system(['rm -rf ' qmudir]);
    else
        error('Existing ''%s'' directory not overwritten.',qmudir);
    end
end
mkdir(qmudir)
cd(qmudir)
system('cp $ISSM_DIR/startup.m .');

%save our model in qmu so that it can be repeatedly used by Dakota.
save('Qmu.model','md')

%create m and in files for dakota
if ~isfield(md.qmu_params(iparams),'analysis_driver') || ...
    isempty(md.qmu_params(iparams).analysis_driver)
    md.qmu_params(iparams).analysis_driver=[ISSM_DIR '/src/m/solutions/dakota/cielo_ice_script.sh'];
end

dakota_in_data(md.qmu_method(imethod),md.variables(ivar),md.responses(iresp),md.qmu_params(iparams),qmufile,package,md);
rundak=input(['Run Dakota analysis ''' qmufile '''? Y/N [N]: '], 's');
if ~strncmpi(rundak,'y',1)
    cd ..
    return
end

%call dakota
system(['dakota -i ' qmufile '.in -o ' qmufile '.out -e ' qmufile '.err']);
% system(['export MPIRUN_NPROCS=8;mpirun -np 4 dakota -i ' qmufile '.in -o ' qmufile '.out -e ' qmufile '.err']);

%parse inputs and results from dakota
[method,dvar,dresp_in]=dakota_in_parse([qmufile '.in']);
md.dakotaresults.method   =method;
md.dakotaresults.dvar     =dvar;
md.dakotaresults.dresp_in =dresp_in;

[method,dresp_out,scm,pcm,srcm,prcm]=dakota_out_parse([qmufile '.out']);
md.dakotaresults.dresp_out=dresp_out;
md.dakotaresults.scm      =scm;
md.dakotaresults.pcm      =pcm;
md.dakotaresults.srcm     =srcm;
md.dakotaresults.prcm     =prcm;

if exist('dakota_tabular.dat','file')
    [method,dresp_dat                  ]=dakota_out_parse('dakota_tabular.dat');
    md.dakotaresults.dresp_dat=dresp_dat;
end

%save input and output files into model
md.dakotain =readfile([qmufile '.in']);
md.dakotaout=readfile([qmufile '.out']);
if exist('dakota_tabular.dat','file')
	md.dakotadat=readfile('dakota_tabular.dat');
end

system('zip -mq params.in.zip params.in.[1-9]*');
system('zip -mq results.out.zip results.out.[1-9]*');
system('zip -mq matlab.out.zip matlab*.out.[1-9]*');

%get out of local directory and erase
cd ../
% system(['rm -rf ' qmudir]);
