/*!\file Calvingx
 * \brief: compute inverse method gradient
 */

#include "./Calvingx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void Calvingx(FemModel* femmodel){

	/*Recover Calving law Enum*/
	int calvinglaw;
	femmodel->parameters->FindParam(&calvinglaw,CalvingLawEnum);

	/*Calculate calving rate*/
	switch(calvinglaw){
		case DefaultCalvingEnum:
		case CalvingMinthicknessEnum:
		case CalvingHabEnum:
			break;
		case CalvingCrevasseDepthEnum:
			femmodel->StrainRateparallelx();
			femmodel->StrainRateeffectivex();
			femmodel->DeviatoricStressx();
			femmodel->ElementOperationx(&Element::CalvingCrevasseDepth);
			break;
		case CalvingLevermannEnum:
			if(VerboseModule()) _printf0_("   computing Levermann's calving rate\n");
			femmodel->StrainRateparallelx();
			femmodel->StrainRateperpendicularx();
			femmodel->CalvingRateLevermannx();
			break;
		case CalvingVonmisesEnum:
		case CalvingDev2Enum:
			femmodel->ElementOperationx(&Element::CalvingRateVonmises);
			break;
		case CalvingTestEnum:
			femmodel->ElementOperationx(&Element::CalvingRateTest);
			break;
		case CalvingParameterizationEnum:
			femmodel->ElementOperationx(&Element::CalvingRateParameterization);
			break;
		default:
			_error_("Caving law "<<EnumToStringx(calvinglaw)<<" not supported yet");
	}
}

void MovingFrontalVelx(FemModel* femmodel){
	femmodel->ElementOperationx(&Element::MovingFrontalVelocity);
}
